<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Nhiệm vụ hàng ngày</h1>
            <p class="page-subtitle text-muted">Quản lý và theo dõi tiến độ công việc</p>
        </div>
        <div class="col-auto">
            <?php if ($_SESSION["user_role"] == "owner" || $_SESSION["user_role"] == "manager"): ?>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addTaskModal">
                <i class="fas fa-plus me-2"></i>Thêm nhiệm vụ
            </button>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Task Statistics -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tổng nhiệm vụ</div>
                        <div class="value text-primary" id="totalTasks">' . count($tasks) . '</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-tasks"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Đã hoàn thành</div>
                        <div class="value text-success" id="completedTasks">' . count(array_filter($tasks, function($task) { return $task['completed']; })) . '</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Đang thực hiện</div>
                        <div class="value text-warning" id="pendingTasks">' . count(array_filter($tasks, function($task) { return !$task['completed']; })) . '</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tỷ lệ hoàn thành</div>
                        <div class="value text-info" id="completionRate">' . (count($tasks) > 0 ? round((count(array_filter($tasks, function($task) { return $task['completed']; })) / count($tasks)) * 100) : 0) . '%</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-percentage"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Task List -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Danh sách nhiệm vụ</h5>
        <div class="task-filters">
            <div class="btn-group" role="group">
                <input type="radio" class="btn-check" name="taskFilter" id="allTasks" autocomplete="off" checked>
                <label class="btn btn-outline-secondary btn-sm" for="allTasks">Tất cả</label>
                
                <input type="radio" class="btn-check" name="taskFilter" id="pendingOnly" autocomplete="off">
                <label class="btn btn-outline-warning btn-sm" for="pendingOnly">Chưa hoàn thành</label>
                
                <input type="radio" class="btn-check" name="taskFilter" id="completedOnly" autocomplete="off">
                <label class="btn btn-outline-success btn-sm" for="completedOnly">Đã hoàn thành</label>
            </div>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="task-list" id="taskList">
            ' . (function() use ($tasks) {
                $html = '';
                if (empty($tasks)) {
                    $html .= '
                    <div class="text-center py-5">
                        <i class="fas fa-tasks text-muted fa-3x mb-3"></i>
                        <h5 class="text-muted">Chưa có nhiệm vụ nào</h5>
                        <p class="text-muted">Hãy thêm nhiệm vụ đầu tiên để bắt đầu</p>
                    </div>';
                } else {
                    foreach($tasks as $task) {
                        $completedClass = $task['completed'] ? 'completed' : '';
                        $html .= '
                        <div class="task-item ' . $completedClass . '" data-status="' . ($task['completed'] ? 'completed' : 'pending') . '">
                            <div class="task-content">
                                <div class="form-check mb-0">
                                    <input class="form-check-input task-checkbox" type="checkbox" 
                                           id="task' . $task['id'] . '" ' . ($task['completed'] ? 'checked' : '') . ' 
                                           data-task-id="' . $task['id'] . '">
                                    <label class="form-check-label w-100" for="task' . $task['id'] . '">
                                        <div class="task-title">' . htmlspecialchars($task['title']) . '</div>
                                        <div class="task-description">' . htmlspecialchars($task['description']) . '</div>
                                        <div class="task-meta">
                                            <small class="text-muted">
                                                <i class="fas fa-user me-1"></i>' . htmlspecialchars($task['created_by']) . '
                                                ' . ($task['completed'] && $task['completed_at'] ? 
                                                    '<i class="fas fa-check ms-3 me-1"></i>Hoàn thành lúc ' . date('H:i d/m', strtotime($task['completed_at'])) : '') . '
                                            </small>
                                        </div>
                                    </label>
                                </div>
                            </div>
                            <div class="task-actions">
                                ' . (!$task['completed'] ? '
                                <button class="btn btn-sm btn-outline-success complete-task-btn" data-task-id="' . $task['id'] . '" title="Hoàn thành">
                                    <i class="fas fa-check"></i>
                                </button>' : '') . '
                                <?php if ($_SESSION["user_role"] == "owner" || $_SESSION["user_role"] == "manager"): ?>
                                <button class="btn btn-sm btn-outline-danger delete-task-btn" data-task-id="' . $task['id'] . '" title="Xóa">
                                    <i class="fas fa-trash"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>';
                    }
                }
                return $html;
            })() . '
        </div>
    </div>
</div>

<!-- Add Task Modal -->
<?php if ($_SESSION["user_role"] == "owner" || $_SESSION["user_role"] == "manager"): ?>
<div class="modal fade" id="addTaskModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Thêm nhiệm vụ mới</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addTaskForm" method="POST" action="/tasks/create">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="taskTitle" class="form-label">Tiêu đề nhiệm vụ</label>
                        <input type="text" class="form-control" id="taskTitle" name="title" required>
                    </div>
                    <div class="mb-3">
                        <label for="taskDescription" class="form-label">Mô tả chi tiết</label>
                        <textarea class="form-control" id="taskDescription" name="description" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">Thêm nhiệm vụ</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<style>
.task-item {
    padding: 1.25rem;
    border-bottom: 1px solid #f8f9fa;
    display: flex;
    align-items: center;
    transition: all 0.3s ease;
}
.task-item:hover {
    background-color: #f8f9fa;
}
.task-item:last-child {
    border-bottom: none;
}
.task-item.completed {
    background-color: #f8fff9;
    opacity: 0.8;
}
.task-item.completed .task-title {
    text-decoration: line-through;
    color: #6c757d;
}
.task-content {
    flex: 1;
}
.task-title {
    font-weight: 600;
    font-size: 1rem;
    margin-bottom: 0.5rem;
    color: #2c3e50;
}
.task-description {
    color: #6c757d;
    font-size: 0.9rem;
    margin-bottom: 0.5rem;
    line-height: 1.4;
}
.task-meta {
    margin-top: 0.5rem;
}
.task-actions {
    display: flex;
    gap: 0.5rem;
    margin-left: 1rem;
}
.task-filters .btn-group {
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
.stat-card {
    border-left: 4px solid;
    transition: all 0.3s ease;
}
.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}
.border-start-primary { border-left-color: #4a90e2 !important; }
.border-start-success { border-left-color: #55efc4 !important; }
.border-start-warning { border-left-color: #fdcb6e !important; }
.border-start-info { border-left-color: #7ed6df !important; }
.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
}
.stat-card.border-start-primary .stat-icon { background: rgba(74, 144, 226, 0.1); color: #4a90e2; }
.stat-card.border-start-success .stat-icon { background: rgba(85, 239, 196, 0.1); color: #55efc4; }
.stat-card.border-start-warning .stat-icon { background: rgba(253, 203, 110, 0.1); color: #fdcb6e; }
.stat-card.border-start-info .stat-icon { background: rgba(126, 214, 223, 0.1); color: #7ed6df; }
.value {
    font-size: 1.75rem;
    font-weight: 700;
    margin: 0.25rem 0;
}
</style>

<script>
// Xử lý hoàn thành nhiệm vụ
document.querySelectorAll(".task-checkbox, .complete-task-btn").forEach(element => {
    element.addEventListener("click", function(e) {
        const taskId = this.dataset.taskId;
        const taskItem = this.closest(".task-item");
        const checkbox = taskItem.querySelector(".task-checkbox");
        
        if (this.classList.contains("complete-task-btn")) {
            checkbox.checked = true;
        }
        
        const completed = checkbox.checked;
        
        // Cập nhật UI ngay lập tức
        if (completed) {
            taskItem.classList.add("completed");
            taskItem.dataset.status = "completed";
        } else {
            taskItem.classList.remove("completed");
            taskItem.dataset.status = "pending";
        }
        
        // Gửi request đến server
        fetch("/api/task/complete", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({
                task_id: taskId,
                completed: completed
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                updateTaskStats();
                // Reload trang để cập nhật thời gian hoàn thành
                if (completed) {
                    setTimeout(() => location.reload(), 500);
                }
            } else {
                // Revert nếu có lỗi
                checkbox.checked = !completed;
                if (completed) {
                    taskItem.classList.remove("completed");
                    taskItem.dataset.status = "pending";
                } else {
                    taskItem.classList.add("completed");
                    taskItem.dataset.status = "completed";
                }
                alert("Có lỗi xảy ra. Vui lòng thử lại.");
            }
        })
        .catch(error => {
            console.error("Error:", error);
            // Revert nếu có lỗi
            checkbox.checked = !completed;
            if (completed) {
                taskItem.classList.remove("completed");
                taskItem.dataset.status = "pending";
            } else {
                taskItem.classList.add("completed");
                taskItem.dataset.status = "completed";
            }
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        });
    });
});

// Xử lý xóa nhiệm vụ
document.querySelectorAll(".delete-task-btn").forEach(button => {
    button.addEventListener("click", function() {
        if (confirm("Bạn có chắc chắn muốn xóa nhiệm vụ này?")) {
            const taskId = this.dataset.taskId;
            const taskItem = this.closest(".task-item");
            
            fetch("/api/task/delete", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                },
                body: JSON.stringify({
                    task_id: taskId
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    taskItem.remove();
                    updateTaskStats();
                } else {
                    alert("Có lỗi xảy ra. Vui lòng thử lại.");
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert("Có lỗi xảy ra. Vui lòng thử lại.");
            });
        }
    });
});

// Xử lý filter nhiệm vụ
document.querySelectorAll("input[name=\"taskFilter\"]").forEach(radio => {
    radio.addEventListener("change", function() {
        const filter = this.id;
        const taskItems = document.querySelectorAll(".task-item");
        
        taskItems.forEach(item => {
            const status = item.dataset.status;
            let show = true;
            
            if (filter === "pendingOnly" && status === "completed") {
                show = false;
            } else if (filter === "completedOnly" && status === "pending") {
                show = false;
            }
            
            item.style.display = show ? "flex" : "none";
        });
    });
});

// Cập nhật thống kê
function updateTaskStats() {
    const allTasks = document.querySelectorAll(".task-item");
    const completedTasks = document.querySelectorAll(".task-item.completed");
    const pendingTasks = allTasks.length - completedTasks.length;
    const completionRate = allTasks.length > 0 ? Math.round((completedTasks.length / allTasks.length) * 100) : 0;
    
    document.getElementById("totalTasks").textContent = allTasks.length;
    document.getElementById("completedTasks").textContent = completedTasks.length;
    document.getElementById("pendingTasks").textContent = pendingTasks;
    document.getElementById("completionRate").textContent = completionRate + "%";
}

// Auto-refresh mỗi 30 giây để cập nhật realtime
setInterval(() => {
    // Chỉ refresh nếu không có modal nào đang mở
    if (!document.querySelector(".modal.show")) {
        location.reload();
    }
}, 30000);
</script>';

include 'layout.php';
?>