<?php
class Router {
    private $routes = [];
    private $params = [];

    public function add($route, $params = []) {
        $this->routes[$route] = $params;
    }

    public function match($url) {
        foreach ($this->routes as $route => $params) {
            if ($url == $route) {
                $this->params = $params;
                return true;
            }
        }
        return false;
    }

    public function dispatch($url) {
        $url = $this->removeQueryStringVariables($url);
        
        if ($this->match($url)) {
            $controller = $this->params['controller'] . 'Controller';
            $controller = ucfirst($controller);
            
            if (class_exists($controller)) {
                $controller_object = new $controller();
                $action = $this->params['action'];
                
                if (is_callable([$controller_object, $action])) {
                    $controller_object->$action();
                } else {
                    throw new Exception("Method $action in controller $controller not found");
                }
            } else {
                throw new Exception("Controller class $controller not found");
            }
        } else {
            throw new Exception('No route matched.', 404);
        }
    }

    protected function removeQueryStringVariables($url) {
        if ($url != '') {
            $parts = explode('&', $url, 2);
            if (strpos($parts[0], '=') === false) {
                $url = $parts[0];
            } else {
                $url = '';
            }
        }
        return $url;
    }
}
?>