<?php
class EmployeeController extends Controller {
    public function index() {
        // Chỉ owner và manager được truy cập
        if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] == 'employee') {
            header('Location: /dashboard');
            exit();
        }
        
        $employeeModel = $this->model('Employee');
        
        if ($_SESSION['user_role'] == 'owner') {
            $employees = $employeeModel->getAllEmployees();
        } else {
            $employees = $employeeModel->getEmployeesByBranch($_SESSION['branch_id']);
        }
        
        $this->view('employees', ['employees' => $employees]);
    }
    
    public function create() {
        header('Content-Type: application/json');
        
        if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] == 'employee') {
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $input = json_decode(file_get_contents('php://input'), true);
            
            $name = $input['name'] ?? '';
            $email = $input['email'] ?? '';
            $phone = $input['phone'] ?? '';
            $role = $input['role'] ?? '';
            $branchId = $input['branch_id'] ?? '';
            $password = $input['password'] ?? '';
            
            $employeeModel = $this->model('Employee');
            $result = $employeeModel->createEmployee($name, $email, $password, $role, $branchId, $phone);
            
            echo json_encode(['success' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid method']);
        }
        exit();
    }
    
    public function delete() {
        header('Content-Type: application/json');
        
        if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] == 'employee') {
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $input = json_decode(file_get_contents('php://input'), true);
            $employeeId = $input['employee_id'] ?? '';
            
            $employeeModel = $this->model('Employee');
            $result = $employeeModel->deleteEmployee($employeeId);
            
            echo json_encode(['success' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid method']);
        }
        exit();
    }
}
?>