<?php
class DepartmentController extends Controller {
    public function index() {
        $this->checkPermission(['owner', 'manager']);
        
        $departmentModel = $this->model('Department');
        $branchModel = $this->model('Branch');
        
        if ($_SESSION['user_role'] == 'owner') {
            $departments = $departmentModel->getAllDepartments();
        } else {
            $departments = $departmentModel->getDepartmentsByBranch($_SESSION['branch_id']);
        }
        
        $branches = $branchModel->getAllBranches();
        
        $this->view('departments', [
            'departments' => $departments,
            'branches' => $branches
        ]);
    }

    public function create() {
        $this->checkPermission(['owner', 'manager']);
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $data = [
                'branch_id' => $_POST['branch_id'],
                'name' => $_POST['name'],
                'description' => $_POST['description'],
                'color' => $_POST['color'],
                'leader_id' => $_POST['leader_id'] ?: null
            ];
            
            $departmentModel = $this->model('Department');
            if ($departmentModel->createDepartment($data)) {
                $_SESSION['success'] = 'Tạo phòng ban thành công!';
            } else {
                $_SESSION['error'] = 'Có lỗi xảy ra khi tạo phòng ban!';
            }
            
            header('Location: /departments');
            exit();
        }
    }

    public function update($id) {
        $this->checkPermission(['owner', 'manager']);
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $data = [
                'name' => $_POST['name'],
                'description' => $_POST['description'],
                'color' => $_POST['color'],
                'leader_id' => $_POST['leader_id'] ?: null
            ];
            
            $departmentModel = $this->model('Department');
            if ($departmentModel->updateDepartment($id, $data)) {
                $_SESSION['success'] = 'Cập nhật phòng ban thành công!';
            } else {
                $_SESSION['error'] = 'Có lỗi xảy ra khi cập nhật!';
            }
            
            header('Location: /departments');
            exit();
        }
    }

    public function delete($id) {
        $this->checkPermission(['owner']);
        
        $departmentModel = $this->model('Department');
        if ($departmentModel->deleteDepartment($id)) {
            $_SESSION['success'] = 'Xóa phòng ban thành công!';
        } else {
            $_SESSION['error'] = 'Có lỗi xảy ra khi xóa phòng ban!';
        }
        
        header('Location: /departments');
        exit();
    }
}
?>