<?php
class AuthController extends Controller {
    public function login() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $email = $_POST['email'] ?? '';
            $password = $_POST['password'] ?? '';
            
            if (empty($email) || empty($password)) {
                $error = 'Vui lòng nhập đầy đủ thông tin';
            } else {
                $userModel = $this->model('User');
                $user = $userModel->getUserByEmail($email);
                
                if ($user && password_verify($password, $user['password'])) {
                    // Đăng nhập thành công
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['user_name'] = $user['name'];
                    $_SESSION['user_email'] = $user['email'];
                    $_SESSION['user_role'] = $user['role'];
                    $_SESSION['branch_id'] = $user['branch_id'];
                    $_SESSION['department_id'] = $user['department_id'];
                    
                    header('Location: /dashboard');
                    exit();
                } else {
                    $error = 'Email hoặc mật khẩu không đúng';
                }
            }
        }
        
        // Hiển thị form đăng nhập
        $this->view('login', [
            'no_layout' => true,
            'error' => $error ?? null
        ]);
    }
    
    public function logout() {
        session_destroy();
        header('Location: /login');
        exit();
    }
}
?>