<?php
// Bắt đầu session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Hiển thị lỗi (chỉ trong môi trường development)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Autoload đơn giản
spl_autoload_register(function ($class_name) {
    $paths = [
        '../app/controllers/',
        '../app/models/', 
        '../app/core/',
        '../app/config/'
    ];
    
    foreach ($paths as $path) {
        $file = $path . $class_name . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// Load config
require_once '../app/config/config.php';
require_once '../app/config/database.php';

// Xử lý URL
$url = isset($_GET['url']) ? $_GET['url'] : 'dashboard';
$url = rtrim($url, '/');
$url = filter_var($url, FILTER_SANITIZE_URL);

// Simple routing
try {
    switch($url) {
        case '':
        case 'dashboard':
            $controller = new DashboardController();
            $controller->index();
            break;
        case 'login':
            $controller = new AuthController();
            $controller->login();
            break;
        case 'logout':
            $controller = new AuthController();
            $controller->logout();
            break;
        case 'tasks':
            $controller = new TaskController();
            $controller->index();
            break;
        case 'kpi':
            $controller = new KpiController();
            $controller->index();
            break;
        case 'branches':
            $controller = new BranchController();
            $controller->index();
            break;
        case 'employees':
            $controller = new EmployeeController();
            $controller->index();
            break;
        case 'sales':
            $controller = new SaleController();
            $controller->index();
            break;
        case 'sales/products':
            $controller = new SaleController();
            $controller->products();
            break;
        case 'sales/services':
            $controller = new SaleController();
            $controller->services();
            break;
        case 'departments':
            $controller = new DepartmentController();
            $controller->index();
            break;
        case 'departments/create':
            $controller = new DepartmentController();
            $controller->create();
            break;
        
        // API Routes
        case 'api/task/complete':
            $controller = new TaskController();
            $controller->complete();
            break;
        case 'api/task/delete':
            $controller = new TaskController();
            $controller->delete();
            break;
        case 'api/sales/create':
            $controller = new SaleController();
            $controller->create();
            break;
        case 'api/sales/recent':
            $controller = new SaleController();
            $controller->recent();
            break;
        case 'api/employees/create':
            $controller = new EmployeeController();
            $controller->create();
            break;
        case 'api/employees/delete':
            $controller = new EmployeeController();
            $controller->delete();
            break;
        case 'api/branches/create':
            $controller = new BranchController();
            $controller->create();
            break;
        case 'settings':
            $controller = new SettingsController();
            $controller->index();
            break;
        
        default:
            http_response_code(404);
            echo "404 - Trang không tồn tại";
            break;
    }
} catch (Exception $e) {
    http_response_code(500);
    echo "Lỗi server: " . $e->getMessage();
    if (APP_DEBUG) {
        echo "<pre>";
        print_r($e->getTrace());
        echo "</pre>";
    }
}
?>