<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Cài đặt hệ thống</h1>
            <p class="page-subtitle text-muted">Quản lý cấu hình và tùy chỉnh hệ thống</p>
        </div>
    </div>
</div>

<div class="row">
    <!-- System Settings -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Cài đặt chung</h5>
            </div>
            <div class="card-body">
                <form id="systemSettingsForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="systemName" class="form-label">Tên hệ thống</label>
                                <input type="text" class="form-control" id="systemName" value="Spa KPI Management System">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="systemVersion" class="form-label">Phiên bản</label>
                                <input type="text" class="form-control" id="systemVersion" value="1.0.0" readonly>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="timezone" class="form-label">Múi giờ</label>
                                <select class="form-select" id="timezone">
                                    <option value="Asia/Ho_Chi_Minh" selected>Việt Nam (UTC+7)</option>
                                    <option value="Asia/Bangkok">Thái Lan (UTC+7)</option>
                                    <option value="Asia/Singapore">Singapore (UTC+8)</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="currency" class="form-label">Đơn vị tiền tệ</label>
                                <select class="form-select" id="currency">
                                    <option value="VND" selected>Việt Nam Đồng (VND)</option>
                                    <option value="USD">US Dollar (USD)</option>
                                    <option value="EUR">Euro (EUR)</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="workingHours" class="form-label">Giờ làm việc</label>
                        <div class="row">
                            <div class="col-md-6">
                                <input type="time" class="form-control" id="startTime" value="08:00">
                                <small class="text-muted">Giờ bắt đầu</small>
                            </div>
                            <div class="col-md-6">
                                <input type="time" class="form-control" id="endTime" value="22:00">
                                <small class="text-muted">Giờ kết thúc</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="autoRefresh" checked>
                            <label class="form-check-label" for="autoRefresh">
                                Tự động làm mới dữ liệu
                            </label>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="notifications" checked>
                            <label class="form-check-label" for="notifications">
                                Bật thông báo hệ thống
                            </label>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Lưu cài đặt</button>
                </form>
            </div>
        </div>
        
        <!-- KPI Settings -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Cài đặt KPI</h5>
            </div>
            <div class="card-body">
                <form id="kpiSettingsForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="defaultServiceTarget" class="form-label">Mục tiêu doanh số dịch vụ mặc định</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="defaultServiceTarget" value="50000000">
                                    <span class="input-group-text">đ</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="defaultProductTarget" class="form-label">Mục tiêu doanh số sản phẩm mặc định</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="defaultProductTarget" value="20000000">
                                    <span class="input-group-text">đ</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kpiUpdateFrequency" class="form-label">Tần suất cập nhật KPI</label>
                                <select class="form-select" id="kpiUpdateFrequency">
                                    <option value="realtime" selected>Thời gian thực</option>
                                    <option value="hourly">Mỗi giờ</option>
                                    <option value="daily">Hàng ngày</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="performanceThreshold" class="form-label">Ngưỡng hiệu suất tốt</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="performanceThreshold" value="80" min="0" max="100">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-success">Lưu cài đặt KPI</button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- System Info & Actions -->
    <div class="col-xl-4 mb-4">
        <!-- System Information -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Thông tin hệ thống</h5>
            </div>
            <div class="card-body">
                <div class="system-info">
                    <div class="info-item mb-3">
                        <div class="d-flex justify-content-between">
                            <span class="info-label">Phiên bản PHP:</span>
                            <span class="info-value">' . phpversion() . '</span>
                        </div>
                    </div>
                    
                    <div class="info-item mb-3">
                        <div class="d-flex justify-content-between">
                            <span class="info-label">Cơ sở dữ liệu:</span>
                            <span class="info-value">MySQL</span>
                        </div>
                    </div>
                    
                    <div class="info-item mb-3">
                        <div class="d-flex justify-content-between">
                            <span class="info-label">Thời gian hoạt động:</span>
                            <span class="info-value" id="uptime">--</span>
                        </div>
                    </div>
                    
                    <div class="info-item mb-3">
                        <div class="d-flex justify-content-between">
                            <span class="info-label">Tổng người dùng:</span>
                            <span class="info-value">12</span>
                        </div>
                    </div>
                    
                    <div class="info-item mb-3">
                        <div class="d-flex justify-content-between">
                            <span class="info-label">Tổng chi nhánh:</span>
                            <span class="info-value">3</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- System Actions -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Thao tác hệ thống</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-info btn-sm" onclick="clearCache()">
                        <i class="fas fa-broom me-2"></i>Xóa cache hệ thống
                    </button>
                    <button class="btn btn-warning btn-sm" onclick="backupDatabase()">
                        <i class="fas fa-database me-2"></i>Sao lưu cơ sở dữ liệu
                    </button>
                    <button class="btn btn-success btn-sm" onclick="exportData()">
                        <i class="fas fa-download me-2"></i>Xuất dữ liệu
                    </button>
                    <button class="btn btn-secondary btn-sm" onclick="viewLogs()">
                        <i class="fas fa-file-alt me-2"></i>Xem nhật ký hệ thống
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Security Settings -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Cài đặt bảo mật</h5>
            </div>
            <div class="card-body">
                <form id="securitySettingsForm">
                    <div class="mb-3">
                        <label for="sessionTimeout" class="form-label">Thời gian hết phiên (phút)</label>
                        <input type="number" class="form-control" id="sessionTimeout" value="60" min="15" max="480">
                    </div>
                    
                    <div class="mb-3">
                        <label for="maxLoginAttempts" class="form-label">Số lần đăng nhập tối đa</label>
                        <input type="number" class="form-control" id="maxLoginAttempts" value="5" min="3" max="10">
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="twoFactorAuth">
                            <label class="form-check-label" for="twoFactorAuth">
                                Xác thực 2 yếu tố
                            </label>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="auditLog" checked>
                            <label class="form-check-label" for="auditLog">
                                Ghi nhật ký hoạt động
                            </label>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-danger btn-sm">Lưu cài đặt bảo mật</button>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.info-item {
    padding: 0.5rem 0;
    border-bottom: 1px solid #f0f0f0;
}
.info-item:last-child {
    border-bottom: none;
}
.info-label {
    font-weight: 500;
    color: #6c757d;
}
.info-value {
    font-weight: 600;
    color: #2c3e50;
}
</style>

<script>
// Update uptime
function updateUptime() {
    const startTime = new Date("2024-01-01"); // Thời gian khởi động hệ thống
    const now = new Date();
    const diff = now - startTime;
    const days = Math.floor(diff / (1000 * 60 * 60 * 24));
    const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    
    document.getElementById("uptime").textContent = days + " ngày " + hours + " giờ";
}

// System Settings Form
document.getElementById("systemSettingsForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    // Collect form data
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    // Simulate API call
    setTimeout(() => {
        alert("Cài đặt hệ thống đã được lưu thành công!");
    }, 500);
});

// KPI Settings Form
document.getElementById("kpiSettingsForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    // Collect form data
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    // Simulate API call
    setTimeout(() => {
        alert("Cài đặt KPI đã được lưu thành công!");
    }, 500);
});

// Security Settings Form
document.getElementById("securitySettingsForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    // Collect form data
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    // Simulate API call
    setTimeout(() => {
        alert("Cài đặt bảo mật đã được lưu thành công!");
    }, 500);
});

// System Actions
function clearCache() {
    if (confirm("Bạn có chắc chắn muốn xóa cache hệ thống?")) {
        // Simulate API call
        setTimeout(() => {
            alert("Cache hệ thống đã được xóa thành công!");
        }, 1000);
    }
}

function backupDatabase() {
    if (confirm("Bạn có muốn tạo bản sao lưu cơ sở dữ liệu?")) {
        // Simulate API call
        setTimeout(() => {
            alert("Sao lưu cơ sở dữ liệu đã hoàn thành!");
        }, 2000);
    }
}

function exportData() {
    alert("Tính năng xuất dữ liệu sẽ được phát triển trong phiên bản tiếp theo");
}

function viewLogs() {
    alert("Tính năng xem nhật ký sẽ được phát triển trong phiên bản tiếp theo");
}

// Initialize
updateUptime();
setInterval(updateUptime, 60000); // Update every minute
</script>';

include 'layout.php';
?>