<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Quản lý doanh số</h1>
            <p class="page-subtitle text-muted">Theo dõi và quản lý doanh thu chi nhánh</p>
        </div>
        <div class="col-auto">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSaleModal">
                <i class="fas fa-plus me-2"></i>Thêm doanh số
            </button>
        </div>
    </div>
</div>

<!-- Sales Overview -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số hôm nay</div>
                        <div class="value text-primary" id="todaySales">' . number_format($todaySales ?? 12500000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+15% so với hôm qua</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số tháng</div>
                        <div class="value text-success" id="monthSales">' . number_format($monthSales ?? 45200000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+8% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số dịch vụ</div>
                        <div class="value text-warning" id="serviceSales">' . number_format(28500000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>63% tổng doanh thu</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-concierge-bell"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số sản phẩm</div>
                        <div class="value text-info" id="productSales">' . number_format(16700000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-warning">
                            <i class="fas fa-minus me-1"></i>
                            <span>37% tổng doanh thu</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-box"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Sales Chart -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Biểu đồ doanh số 30 ngày gần nhất</h5>
                <div class="chart-controls">
                    <div class="btn-group btn-group-sm" role="group">
                        <input type="radio" class="btn-check" name="chartType" id="lineChart" autocomplete="off" checked>
                        <label class="btn btn-outline-secondary" for="lineChart">Đường</label>
                        
                        <input type="radio" class="btn-check" name="chartType" id="barChart" autocomplete="off">
                        <label class="btn btn-outline-secondary" for="barChart">Cột</label>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="salesChart"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Sales by Category -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Doanh số theo danh mục</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="chart-container">
                            <canvas id="categoryChart"></canvas>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="category-stats">
                            <div class="category-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="category-info">
                                        <div class="category-name">Massage & Thư giãn</div>
                                        <div class="category-count text-muted small">45 lượt</div>
                                    </div>
                                    <div class="category-amount">
                                        <div class="amount">18,500,000đ</div>
                                        <div class="percentage text-success">+12%</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="category-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="category-info">
                                        <div class="category-name">Chăm sóc da mặt</div>
                                        <div class="category-count text-muted small">32 lượt</div>
                                    </div>
                                    <div class="category-amount">
                                        <div class="amount">15,200,000đ</div>
                                        <div class="percentage text-success">+8%</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="category-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="category-info">
                                        <div class="category-name">Sản phẩm chăm sóc</div>
                                        <div class="category-count text-muted small">28 sản phẩm</div>
                                    </div>
                                    <div class="category-amount">
                                        <div class="amount">11,500,000đ</div>
                                        <div class="percentage text-warning">-3%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Sales & Top Performers -->
    <div class="col-xl-4 mb-4">
        <!-- Recent Sales -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Giao dịch gần đây</h5>
                <button class="btn btn-sm btn-outline-primary" onclick="refreshSales()">
                    <i class="fas fa-sync-alt"></i>
                </button>
            </div>
            <div class="card-body p-0">
                <div class="sales-list" id="recentSalesList">
                    ' . (function() use ($recentSales) {
                        $html = '';
                        $sampleSales = $recentSales ?? [
                            ['sale_date' => date('Y-m-d H:i:s'), 'type' => 'service', 'description' => 'Massage thư giãn 90 phút', 'amount' => 650000, 'employee_name' => 'Nguyễn Thị A'],
                            ['sale_date' => date('Y-m-d H:i:s', strtotime('-1 hour')), 'type' => 'product', 'description' => 'Kem dưỡng da cao cấp', 'amount' => 420000, 'employee_name' => 'Trần Văn B'],
                            ['sale_date' => date('Y-m-d H:i:s', strtotime('-2 hours')), 'type' => 'service', 'description' => 'Chăm sóc da mặt chuyên sâu', 'amount' => 850000, 'employee_name' => 'Lê Thị C'],
                            ['sale_date' => date('Y-m-d H:i:s', strtotime('-3 hours')), 'type' => 'product', 'description' => 'Serum vitamin C', 'amount' => 320000, 'employee_name' => 'Phạm Văn D'],
                            ['sale_date' => date('Y-m-d H:i:s', strtotime('-4 hours')), 'type' => 'service', 'description' => 'Tắm trắng toàn thân', 'amount' => 750000, 'employee_name' => 'Hoàng Thị E']
                        ];
                        
                        foreach($sampleSales as $sale) {
                            $typeIcon = $sale['type'] == 'service' ? 'fa-concierge-bell' : 'fa-box';
                            $typeColor = $sale['type'] == 'service' ? 'primary' : 'success';
                            $typeText = $sale['type'] == 'service' ? 'Dịch vụ' : 'Sản phẩm';
                            
                            $html .= '
                            <div class="sale-item p-3 border-bottom">
                                <div class="d-flex align-items-center">
                                    <div class="sale-icon me-3">
                                        <i class="fas ' . $typeIcon . ' text-' . $typeColor . '"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="sale-description">' . htmlspecialchars($sale['description']) . '</div>
                                        <div class="sale-meta text-muted small">
                                            ' . date('H:i', strtotime($sale['sale_date'])) . ' • ' . htmlspecialchars($sale['employee_name']) . '
                                        </div>
                                    </div>
                                    <div class="sale-amount text-end">
                                        <div class="fw-bold text-' . $typeColor . '">' . number_format((float)$sale['amount'], 0, ',', '.') . 'đ</div>
                                        <small class="text-muted">' . $typeText . '</small>
                                    </div>
                                </div>
                            </div>';
                        }
                        return $html;
                    })() . '
                </div>
            </div>
        </div>
        
        <!-- Top Performers -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Top nhân viên bán hàng</h5>
            </div>
            <div class="card-body p-0">
                <div class="performer-list">
                    <div class="performer-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="performer-rank me-3">
                                <span class="badge bg-warning">1</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="performer-name">Nguyễn Thị A</div>
                                <div class="performer-stats text-muted small">25 giao dịch</div>
                            </div>
                            <div class="performer-amount text-end">
                                <div class="fw-bold">8,500,000đ</div>
                                <div class="text-success small">+15%</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="performer-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="performer-rank me-3">
                                <span class="badge bg-secondary">2</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="performer-name">Trần Văn B</div>
                                <div class="performer-stats text-muted small">22 giao dịch</div>
                            </div>
                            <div class="performer-amount text-end">
                                <div class="fw-bold">7,200,000đ</div>
                                <div class="text-success small">+8%</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="performer-item p-3">
                        <div class="d-flex align-items-center">
                            <div class="performer-rank me-3">
                                <span class="badge bg-info">3</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="performer-name">Lê Thị C</div>
                                <div class="performer-stats text-muted small">18 giao dịch</div>
                            </div>
                            <div class="performer-amount text-end">
                                <div class="fw-bold">6,800,000đ</div>
                                <div class="text-warning small">-2%</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Sale Modal -->
<div class="modal fade" id="addSaleModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Thêm doanh số mới</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addSaleForm" method="POST" action="/api/sales/create">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="saleType" class="form-label">Loại giao dịch</label>
                        <select class="form-select" id="saleType" name="type" required>
                            <option value="">Chọn loại giao dịch</option>
                            <option value="service">Dịch vụ</option>
                            <option value="product">Sản phẩm</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="saleDescription" class="form-label">Mô tả</label>
                        <input type="text" class="form-control" id="saleDescription" name="description" required>
                    </div>
                    <div class="mb-3">
                        <label for="saleAmount" class="form-label">Số tiền</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="saleAmount" name="amount" required min="0">
                            <span class="input-group-text">đ</span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="saleDate" class="form-label">Thời gian</label>
                        <input type="datetime-local" class="form-control" id="saleDate" name="sale_date" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">Thêm doanh số</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.sale-icon {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f8f9fa;
}
.sale-description {
    font-weight: 500;
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}
.sale-meta {
    font-size: 0.8rem;
}
.sale-amount {
    min-width: 100px;
}
.category-item {
    padding: 0.75rem 0;
    border-bottom: 1px solid #f0f0f0;
}
.category-item:last-child {
    border-bottom: none;
}
.category-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.category-count {
    font-size: 0.8rem;
}
.amount {
    font-weight: 600;
    font-size: 0.9rem;
}
.percentage {
    font-size: 0.8rem;
    font-weight: 500;
}
.performer-rank .badge {
    width: 24px;
    height: 24px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
}
.performer-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.performer-stats {
    font-size: 0.8rem;
}
.performer-amount {
    min-width: 100px;
}
</style>

<script>
// Sales Chart
const salesCtx = document.getElementById("salesChart").getContext("2d");
let salesChart = new Chart(salesCtx, {
    type: "line",
    data: {
        labels: Array.from({length: 30}, (_, i) => {
            const date = new Date();
            date.setDate(date.getDate() - (29 - i));
            return date.getDate() + "/" + (date.getMonth() + 1);
        }),
        datasets: [{
            label: "Doanh số dịch vụ",
            data: Array.from({length: 30}, () => Math.floor(Math.random() * 2000000) + 500000),
            borderColor: "#4a90e2",
            backgroundColor: "rgba(74, 144, 226, 0.1)",
            borderWidth: 2,
            tension: 0.4,
            fill: true
        }, {
            label: "Doanh số sản phẩm",
            data: Array.from({length: 30}, () => Math.floor(Math.random() * 1000000) + 200000),
            borderColor: "#55efc4",
            backgroundColor: "rgba(85, 239, 196, 0.1)",
            borderWidth: 2,
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: "bottom"
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return context.dataset.label + ": " + 
                               new Intl.NumberFormat("vi-VN", { 
                                   style: "currency", 
                                   currency: "VND",
                                   minimumFractionDigits: 0 
                               }).format(context.raw);
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        if (value >= 1000000) {
                            return (value / 1000000) + " tr";
                        }
                        return new Intl.NumberFormat("vi-VN", { 
                            style: "currency", 
                            currency: "VND", 
                            minimumFractionDigits: 0 
                        }).format(value);
                    }
                }
            }
        }
    }
});

// Category Chart
const categoryCtx = document.getElementById("categoryChart").getContext("2d");
const categoryChart = new Chart(categoryCtx, {
    type: "doughnut",
    data: {
        labels: ["Massage & Thư giãn", "Chăm sóc da mặt", "Sản phẩm chăm sóc", "Khác"],
        datasets: [{
            data: [18500000, 15200000, 11500000, 3800000],
            backgroundColor: [
                "#4a90e2",
                "#55efc4", 
                "#fdcb6e",
                "#e17055"
            ],
            borderWidth: 0
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: "bottom",
                labels: {
                    usePointStyle: true,
                    padding: 15
                }
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const total = context.dataset.data.reduce((a, b) => a + b, 0);
                        const percentage = ((context.raw / total) * 100).toFixed(1);
                        return context.label + ": " + 
                               new Intl.NumberFormat("vi-VN", { 
                                   style: "currency", 
                                   currency: "VND",
                                   minimumFractionDigits: 0 
                               }).format(context.raw) + 
                               " (" + percentage + "%)";
                    }
                }
            }
        }
    }
});

// Chart type toggle
document.querySelectorAll("input[name=\"chartType\"]").forEach(radio => {
    radio.addEventListener("change", function() {
        salesChart.destroy();
        salesChart = new Chart(salesCtx, {
            type: this.id === "lineChart" ? "line" : "bar",
            data: salesChart.data,
            options: salesChart.options
        });
    });
});

// Add sale form
document.getElementById("addSaleForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    fetch("/api/sales/create", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById("addSaleModal")).hide();
            location.reload();
        } else {
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        }
    })
    .catch(error => {
        console.error("Error:", error);
        alert("Có lỗi xảy ra. Vui lòng thử lại.");
    });
});

// Set default datetime
document.getElementById("saleDate").value = new Date().toISOString().slice(0, 16);

// Refresh sales
function refreshSales() {
    location.reload();
}

// Auto-refresh mỗi 30 giây
setInterval(() => {
    if (!document.querySelector(".modal.show")) {
        // Chỉ refresh danh sách giao dịch, không reload toàn trang
        fetch("/api/sales/recent")
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Cập nhật danh sách giao dịch
                updateRecentSales(data.sales);
            }
        })
        .catch(error => console.error("Error:", error));
    }
}, 30000);

function updateRecentSales(sales) {
    // Function để cập nhật danh sách giao dịch realtime
    // Sẽ được implement khi có API
}
</script>';

include 'layout.php';
?>