<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Quản lý phòng ban</h1>
            <p class="page-subtitle text-muted">Tổ chức và quản lý các phòng ban trong hệ thống</p>
        </div>
        <div class="col-auto">
            <?php if ($_SESSION["user_role"] == "owner" || $_SESSION["user_role"] == "manager"): ?>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addDepartmentModal">
                <i class="fas fa-plus me-2"></i>Thêm phòng ban
            </button>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Department Statistics -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tổng phòng ban</div>
                        <div class="value text-primary" id="totalDepartments">' . count($departments) . '</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>Hoạt động tốt</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-sitemap"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tổng nhân viên</div>
                        <div class="value text-success" id="totalEmployees">' . array_sum(array_column($departments, 'employee_count')) . '</div>
                        <div class="trend text-success">
                            <i class="fas fa-users me-1"></i>
                            <span>Đang hoạt động</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Phòng ban lớn nhất</div>
                        <div class="value text-warning" id="largestDept">' . (empty($departments) ? 0 : max(array_column($departments, 'employee_count'))) . '</div>
                        <div class="trend text-info">
                            <i class="fas fa-crown me-1"></i>
                            <span>Nhân viên</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Trung bình/phòng ban</div>
                        <div class="value text-info" id="avgEmployees">' . (count($departments) > 0 ? round(array_sum(array_column($departments, 'employee_count')) / count($departments), 1) : 0) . '</div>
                        <div class="trend text-success">
                            <i class="fas fa-calculator me-1"></i>
                            <span>Nhân viên</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Department List -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Danh sách phòng ban</h5>
                <div class="department-filters">
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" placeholder="Tìm kiếm phòng ban..." id="departmentSearch">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            Lọc
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item filter-option" href="#" data-filter="all">Tất cả</a></li>
                            <li><a class="dropdown-item filter-option" href="#" data-filter="has-leader">Có trưởng phòng</a></li>
                            <li><a class="dropdown-item filter-option" href="#" data-filter="no-leader">Chưa có trưởng phòng</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0" id="departmentTable">
                        <thead class="table-light">
                            <tr>
                                <th>Phòng ban</th>
                                <th>Chi nhánh</th>
                                <th>Trưởng phòng</th>
                                <th>Số nhân viên</th>
                                <th>Mô tả</th>
                                <th>Thao tác</th>
                            </tr>
                        </thead>
                        <tbody>
                            ' . (function() use ($departments) {
                                $html = '';
                                if (empty($departments)) {
                                    $html .= '
                                    <tr>
                                        <td colspan="6" class="text-center py-4">
                                            <i class="fas fa-sitemap text-muted fa-2x mb-2"></i>
                                            <p class="text-muted">Chưa có phòng ban nào</p>
                                        </td>
                                    </tr>';
                                } else {
                                    foreach($departments as $dept) {
                                        $hasLeader = !empty($dept['leader_name']);
                                        $html .= '
                                        <tr class="department-row" data-has-leader="' . ($hasLeader ? 'true' : 'false') . '">
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="department-color me-3" style="background-color: ' . htmlspecialchars($dept['color']) . '"></div>
                                                    <div>
                                                        <div class="department-name">' . htmlspecialchars($dept['name']) . '</div>
                                                        <div class="department-id text-muted small">ID: ' . $dept['id'] . '</div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>' . htmlspecialchars($dept['branch_name']) . '</td>
                                            <td>
                                                ' . ($hasLeader ? 
                                                    '<div class="leader-info">
                                                        <div class="leader-name">' . htmlspecialchars($dept['leader_name']) . '</div>
                                                        <div class="leader-badge">
                                                            <span class="badge bg-primary">Trưởng phòng</span>
                                                        </div>
                                                    </div>' : 
                                                    '<span class="text-muted">Chưa có trưởng phòng</span>') . '
                                            </td>
                                            <td>
                                                <div class="employee-count">
                                                    <span class="fw-bold">' . (int)$dept['employee_count'] . '</span> nhân viên
                                                </div>
                                            </td>
                                            <td>
                                                <div class="department-description">
                                                    ' . (strlen($dept['description']) > 50 ? 
                                                        substr(htmlspecialchars($dept['description']), 0, 50) . '...' : 
                                                        htmlspecialchars($dept['description'])) . '
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <button class="btn btn-outline-primary" onclick="viewDepartment(' . $dept['id'] . ')" title="Xem chi tiết">
                                                        <i class="fas fa-eye"></i>
                                                    </button>
                                                    <?php if ($_SESSION["user_role"] == "owner" || $_SESSION["user_role"] == "manager"): ?>
                                                    <button class="btn btn-outline-secondary" onclick="editDepartment(' . $dept['id'] . ')" title="Chỉnh sửa">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <?php if ($_SESSION["user_role"] == "owner"): ?>
                                                    <button class="btn btn-outline-danger" onclick="deleteDepartment(' . $dept['id'] . ')" title="Xóa">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>';
                                    }
                                }
                                return $html;
                            })() . '
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Department Analytics -->
    <div class="col-xl-4 mb-4">
        <!-- Department Distribution -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Phân bố phòng ban theo chi nhánh</h5>
            </div>
            <div class="card-body">
                <div class="branch-distribution">
                    ' . (function() use ($departments, $branches) {
                        $html = '';
                        $branchCounts = [];
                        
                        // Đếm số phòng ban theo chi nhánh
                        foreach($departments as $dept) {
                            $branchName = $dept['branch_name'];
                            if (!isset($branchCounts[$branchName])) {
                                $branchCounts[$branchName] = 0;
                            }
                            $branchCounts[$branchName]++;
                        }
                        
                        $total = array_sum($branchCounts);
                        
                        foreach($branchCounts as $branchName => $count) {
                            $percentage = $total > 0 ? round(($count / $total) * 100) : 0;
                            $html .= '
                            <div class="branch-item mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="branch-name">' . htmlspecialchars($branchName) . '</span>
                                    <span class="branch-count fw-bold">' . $count . ' phòng ban</span>
                                </div>
                                <div class="progress thin-progress">
                                    <div class="progress-bar bg-primary" style="width: ' . $percentage . '%"></div>
                                </div>
                                <div class="branch-percentage text-muted small mt-1">' . $percentage . '% tổng số</div>
                            </div>';
                        }
                        
                        if (empty($branchCounts)) {
                            $html .= '
                            <div class="text-center py-3">
                                <i class="fas fa-chart-pie text-muted fa-2x mb-2"></i>
                                <p class="text-muted">Chưa có dữ liệu</p>
                            </div>';
                        }
                        
                        return $html;
                    })() . '
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Thao tác nhanh</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-primary btn-sm" onclick="exportDepartmentReport()">
                        <i class="fas fa-download me-2"></i>Xuất báo cáo phòng ban
                    </button>
                    <button class="btn btn-success btn-sm" onclick="assignLeaders()">
                        <i class="fas fa-user-tie me-2"></i>Phân công trưởng phòng
                    </button>
                    <button class="btn btn-info btn-sm" onclick="reorganizeDepartments()">
                        <i class="fas fa-sitemap me-2"></i>Tổ chức lại phòng ban
                    </button>
                    <button class="btn btn-warning btn-sm" onclick="departmentAnalytics()">
                        <i class="fas fa-chart-bar me-2"></i>Phân tích hiệu suất
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Recent Activities -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Hoạt động gần đây</h5>
            </div>
            <div class="card-body p-0">
                <div class="activity-list">
                    <div class="activity-item p-3 border-bottom">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-plus text-success"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text">Tạo phòng ban mới: <strong>Marketing Digital</strong></div>
                                <div class="activity-time text-muted small">2 giờ trước</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="activity-item p-3 border-bottom">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-user-tie text-info"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text">Bổ nhiệm trưởng phòng: <strong>Phòng Chăm sóc da</strong></div>
                                <div class="activity-time text-muted small">5 giờ trước</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="activity-item p-3">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-edit text-warning"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text">Cập nhật mô tả: <strong>Phòng Massage</strong></div>
                                <div class="activity-time text-muted small">1 ngày trước</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Department Modal -->
<?php if ($_SESSION["user_role"] == "owner" || $_SESSION["user_role"] == "manager"): ?>
<div class="modal fade" id="addDepartmentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Thêm phòng ban mới</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addDepartmentForm" method="POST" action="/departments/create">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="departmentBranch" class="form-label">Chi nhánh</label>
                        <select class="form-select" id="departmentBranch" name="branch_id" required>
                            <option value="">Chọn chi nhánh</option>
                            ' . (function() use ($branches) {
                                $html = '';
                                foreach($branches as $branch) {
                                    $html .= '<option value="' . $branch['id'] . '">' . htmlspecialchars($branch['name']) . '</option>';
                                }
                                return $html;
                            })() . '
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="departmentName" class="form-label">Tên phòng ban</label>
                        <input type="text" class="form-control" id="departmentName" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="departmentDescription" class="form-label">Mô tả</label>
                        <textarea class="form-control" id="departmentDescription" name="description" rows="3"></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="departmentColor" class="form-label">Màu sắc</label>
                                <input type="color" class="form-control form-control-color" id="departmentColor" name="color" value="#667eea">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="departmentLeader" class="form-label">Trưởng phòng</label>
                                <select class="form-select" id="departmentLeader" name="leader_id">
                                    <option value="">Chọn sau</option>
                                    <!-- Options sẽ được load bằng JavaScript khi chọn chi nhánh -->
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">Thêm phòng ban</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<style>
.department-color {
    width: 20px;
    height: 20px;
    border-radius: 4px;
    border: 1px solid #ddd;
}
.department-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.department-id {
    font-size: 0.8rem;
}
.leader-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.employee-count .fw-bold {
    font-size: 1.1rem;
}
.department-description {
    font-size: 0.9rem;
    color: #6c757d;
}
.branch-item {
    padding: 0.5rem 0;
}
.branch-name {
    font-weight: 500;
}
.branch-count {
    font-size: 0.9rem;
}
.branch-percentage {
    font-size: 0.8rem;
}
</style>

<script>
// Search functionality
document.getElementById("departmentSearch").addEventListener("input", function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll(".department-row");
    
    rows.forEach(row => {
        const name = row.querySelector(".department-name").textContent.toLowerCase();
        const branch = row.cells[1].textContent.toLowerCase();
        const leader = row.cells[2].textContent.toLowerCase();
        
        if (name.includes(searchTerm) || branch.includes(searchTerm) || leader.includes(searchTerm)) {
            row.style.display = "";
        } else {
            row.style.display = "none";
        }
    });
});

// Filter functionality
document.querySelectorAll(".filter-option").forEach(option => {
    option.addEventListener("click", function(e) {
        e.preventDefault();
        const filter = this.dataset.filter;
        const rows = document.querySelectorAll(".department-row");
        
        rows.forEach(row => {
            let show = true;
            
            if (filter === "has-leader" && row.dataset.hasLeader !== "true") {
                show = false;
            } else if (filter === "no-leader" && row.dataset.hasLeader !== "false") {
                show = false;
            }
            
            row.style.display = show ? "" : "none";
        });
    });
});

// Department actions
function viewDepartment(id) {
    alert("Xem chi tiết phòng ban ID: " + id);
}

function editDepartment(id) {
    alert("Chỉnh sửa phòng ban ID: " + id);
}

function deleteDepartment(id) {
    if (confirm("Bạn có chắc chắn muốn xóa phòng ban này? Hành động này không thể hoàn tác.")) {
        fetch("/departments/delete/" + id, {
            method: "POST"
        })
        .then(response => {
            if (response.ok) {
                location.reload();
            } else {
                alert("Có lỗi xảy ra. Vui lòng thử lại.");
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        });
    }
}

// Quick actions
function exportDepartmentReport() {
    alert("Tính năng xuất báo cáo sẽ được phát triển trong phiên bản tiếp theo");
}

function assignLeaders() {
    alert("Tính năng phân công trưởng phòng sẽ được phát triển trong phiên bản tiếp theo");
}

function reorganizeDepartments() {
    alert("Tính năng tổ chức lại phòng ban sẽ được phát triển trong phiên bản tiếp theo");
}

function departmentAnalytics() {
    alert("Tính năng phân tích hiệu suất sẽ được phát triển trong phiên bản tiếp theo");
}

// Load employees when branch is selected
document.getElementById("departmentBranch").addEventListener("change", function() {
    const branchId = this.value;
    const leaderSelect = document.getElementById("departmentLeader");
    
    // Clear current options
    leaderSelect.innerHTML = "<option value=\"\">Đang tải...</option>";
    
    if (branchId) {
        // Simulate loading employees from selected branch
        setTimeout(() => {
            leaderSelect.innerHTML = `
                <option value="">Chọn trưởng phòng</option>
                <option value="1">Nguyễn Văn A</option>
                <option value="2">Trần Thị B</option>
                <option value="3">Lê Văn C</option>
            `;
        }, 500);
    } else {
        leaderSelect.innerHTML = "<option value=\"\">Chọn chi nhánh trước</option>";
    }
});

// Auto-refresh mỗi 60 giây
setInterval(() => {
    if (!document.querySelector(".modal.show")) {
        location.reload();
    }
}, 60000);
</script>';

include 'layout.php';
?>