<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Quản lý chi nhánh</h1>
            <p class="page-subtitle text-muted">Theo dõi hiệu suất và quản lý các chi nhánh</p>
        </div>
        <div class="col-auto">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addBranchModal">
                <i class="fas fa-plus me-2"></i>Thêm chi nhánh
            </button>
        </div>
    </div>
</div>

<!-- Branch Overview -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tổng chi nhánh</div>
                        <div class="value text-primary" id="totalBranches">3</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+1 chi nhánh mới</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-code-branch"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh thu tổng</div>
                        <div class="value text-success" id="totalRevenue">' . number_format(125000000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+12% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Chi nhánh hiệu quả nhất</div>
                        <div class="value text-warning" id="topBranch">CN Quận 1</div>
                        <div class="trend text-success">
                            <i class="fas fa-crown me-1"></i>
                            <span>95% hiệu suất</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-trophy"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tổng nhân viên</div>
                        <div class="value text-info" id="totalStaff">28</div>
                        <div class="trend text-success">
                            <i class="fas fa-users me-1"></i>
                            <span>Trung bình 9.3/chi nhánh</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Branch Performance Chart -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">So sánh hiệu suất chi nhánh</h5>
                <div class="chart-controls">
                    <div class="btn-group btn-group-sm" role="group">
                        <input type="radio" class="btn-check" name="chartPeriod" id="thisMonth" autocomplete="off" checked>
                        <label class="btn btn-outline-secondary" for="thisMonth">Tháng này</label>
                        
                        <input type="radio" class="btn-check" name="chartPeriod" id="lastMonth" autocomplete="off">
                        <label class="btn btn-outline-secondary" for="lastMonth">Tháng trước</label>
                        
                        <input type="radio" class="btn-check" name="chartPeriod" id="quarter" autocomplete="off">
                        <label class="btn btn-outline-secondary" for="quarter">Quý này</label>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="branchChart"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Branch List -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Danh sách chi nhánh</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Chi nhánh</th>
                                <th>Địa chỉ</th>
                                <th>Quản lý</th>
                                <th>Nhân viên</th>
                                <th>Doanh thu tháng</th>
                                <th>Hiệu suất</th>
                                <th>Trạng thái</th>
                                <th>Thao tác</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="branch-icon me-3">
                                            <i class="fas fa-store text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="branch-name">Chi nhánh Quận 1</div>
                                            <div class="branch-code text-muted small">CN001</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="branch-address">123 Nguyễn Huệ, Q1, TP.HCM</div>
                                    <div class="branch-phone text-muted small">0901 234 567</div>
                                </td>
                                <td>
                                    <div class="manager-info">
                                        <div class="manager-name">Nguyễn Thị A</div>
                                        <div class="manager-contact text-muted small">nguyena@spa.com</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="staff-count">
                                        <span class="fw-bold">12</span> nhân viên
                                        <div class="staff-status text-muted small">10 đang làm việc</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="revenue">
                                        <div class="fw-bold text-success">' . number_format(55000000, 0, ',', '.') . 'đ</div>
                                        <div class="revenue-growth text-success small">+15%</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="performance-bar me-2">
                                            <div class="progress" style="width: 60px; height: 6px;">
                                                <div class="progress-bar bg-success" style="width: 95%"></div>
                                            </div>
                                        </div>
                                        <span class="text-success fw-bold">95%</span>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-success">Hoạt động</span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="viewBranch(1)" title="Xem chi tiết">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-outline-secondary" onclick="editBranch(1)" title="Chỉnh sửa">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-outline-info" onclick="viewReport(1)" title="Báo cáo">
                                            <i class="fas fa-chart-bar"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="branch-icon me-3">
                                            <i class="fas fa-store text-success"></i>
                                        </div>
                                        <div>
                                            <div class="branch-name">Chi nhánh Quận 3</div>
                                            <div class="branch-code text-muted small">CN002</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="branch-address">456 Võ Văn Tần, Q3, TP.HCM</div>
                                    <div class="branch-phone text-muted small">0901 345 678</div>
                                </td>
                                <td>
                                    <div class="manager-info">
                                        <div class="manager-name">Trần Văn B</div>
                                        <div class="manager-contact text-muted small">tranb@spa.com</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="staff-count">
                                        <span class="fw-bold">8</span> nhân viên
                                        <div class="staff-status text-muted small">7 đang làm việc</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="revenue">
                                        <div class="fw-bold text-success">' . number_format(42000000, 0, ',', '.') . 'đ</div>
                                        <div class="revenue-growth text-success small">+8%</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="performance-bar me-2">
                                            <div class="progress" style="width: 60px; height: 6px;">
                                                <div class="progress-bar bg-warning" style="width: 82%"></div>
                                            </div>
                                        </div>
                                        <span class="text-warning fw-bold">82%</span>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-success">Hoạt động</span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="viewBranch(2)" title="Xem chi tiết">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-outline-secondary" onclick="editBranch(2)" title="Chỉnh sửa">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-outline-info" onclick="viewReport(2)" title="Báo cáo">
                                            <i class="fas fa-chart-bar"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="branch-icon me-3">
                                            <i class="fas fa-store text-info"></i>
                                        </div>
                                        <div>
                                            <div class="branch-name">Chi nhánh Quận 7</div>
                                            <div class="branch-code text-muted small">CN003</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="branch-address">789 Nguyễn Thị Thập, Q7, TP.HCM</div>
                                    <div class="branch-phone text-muted small">0901 456 789</div>
                                </td>
                                <td>
                                    <div class="manager-info">
                                        <div class="manager-name">Lê Thị C</div>
                                        <div class="manager-contact text-muted small">lec@spa.com</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="staff-count">
                                        <span class="fw-bold">8</span> nhân viên
                                        <div class="staff-status text-muted small">6 đang làm việc</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="revenue">
                                        <div class="fw-bold text-success">' . number_format(28000000, 0, ',', '.') . 'đ</div>
                                        <div class="revenue-growth text-warning small">+2%</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="performance-bar me-2">
                                            <div class="progress" style="width: 60px; height: 6px;">
                                                <div class="progress-bar bg-danger" style="width: 68%"></div>
                                            </div>
                                        </div>
                                        <span class="text-danger fw-bold">68%</span>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-warning">Cần cải thiện</span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="viewBranch(3)" title="Xem chi tiết">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-outline-secondary" onclick="editBranch(3)" title="Chỉnh sửa">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-outline-info" onclick="viewReport(3)" title="Báo cáo">
                                            <i class="fas fa-chart-bar"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Branch Analytics & Quick Actions -->
    <div class="col-xl-4 mb-4">
        <!-- Performance Ranking -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Bảng xếp hạng chi nhánh</h5>
            </div>
            <div class="card-body p-0">
                <div class="ranking-list">
                    <div class="ranking-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="ranking-position me-3">
                                <span class="badge bg-warning">1</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="ranking-name">Chi nhánh Quận 1</div>
                                <div class="ranking-metrics text-muted small">95% hiệu suất • 55M doanh thu</div>
                            </div>
                            <div class="ranking-badge">
                                <i class="fas fa-crown text-warning"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="ranking-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="ranking-position me-3">
                                <span class="badge bg-secondary">2</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="ranking-name">Chi nhánh Quận 3</div>
                                <div class="ranking-metrics text-muted small">82% hiệu suất • 42M doanh thu</div>
                            </div>
                            <div class="ranking-badge">
                                <i class="fas fa-medal text-secondary"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="ranking-item p-3">
                        <div class="d-flex align-items-center">
                            <div class="ranking-position me-3">
                                <span class="badge bg-info">3</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="ranking-name">Chi nhánh Quận 7</div>
                                <div class="ranking-metrics text-muted small">68% hiệu suất • 28M doanh thu</div>
                            </div>
                            <div class="ranking-badge">
                                <i class="fas fa-exclamation-triangle text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Thao tác nhanh</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-primary btn-sm" onclick="compareBranches()">
                        <i class="fas fa-balance-scale me-2"></i>So sánh chi nhánh
                    </button>
                    <button class="btn btn-success btn-sm" onclick="exportBranchReport()">
                        <i class="fas fa-download me-2"></i>Xuất báo cáo tổng hợp
                    </button>
                    <button class="btn btn-info btn-sm" onclick="scheduleMeeting()">
                        <i class="fas fa-calendar me-2"></i>Lên lịch họp quản lý
                    </button>
                    <button class="btn btn-warning btn-sm" onclick="sendAlert()">
                        <i class="fas fa-bell me-2"></i>Gửi cảnh báo hiệu suất
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Recent Activities -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Hoạt động gần đây</h5>
            </div>
            <div class="card-body p-0">
                <div class="activity-list">
                    <div class="activity-item p-3 border-bottom">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-chart-line text-success"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text"><strong>CN Quận 1</strong> vượt mục tiêu doanh thu 15%</div>
                                <div class="activity-time text-muted small">2 giờ trước</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="activity-item p-3 border-bottom">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-user-plus text-info"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text"><strong>CN Quận 3</strong> tuyển thêm 2 nhân viên mới</div>
                                <div class="activity-time text-muted small">5 giờ trước</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="activity-item p-3">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-exclamation-triangle text-warning"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text"><strong>CN Quận 7</strong> cần hỗ trợ cải thiện hiệu suất</div>
                                <div class="activity-time text-muted small">1 ngày trước</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Branch Modal -->
<div class="modal fade" id="addBranchModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Thêm chi nhánh mới</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addBranchForm" method="POST" action="/api/branches/create">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="branchName" class="form-label">Tên chi nhánh</label>
                                <input type="text" class="form-control" id="branchName" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="branchCode" class="form-label">Mã chi nhánh</label>
                                <input type="text" class="form-control" id="branchCode" name="code" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="branchAddress" class="form-label">Địa chỉ</label>
                        <textarea class="form-control" id="branchAddress" name="address" rows="2" required></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="branchPhone" class="form-label">Số điện thoại</label>
                                <input type="tel" class="form-control" id="branchPhone" name="phone" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="branchEmail" class="form-label">Email</label>
                                <input type="email" class="form-control" id="branchEmail" name="email">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="branchManager" class="form-label">Quản lý chi nhánh</label>
                                <select class="form-select" id="branchManager" name="manager_id" required>
                                    <option value="">Chọn quản lý</option>
                                    <option value="1">Nguyễn Thị A</option>
                                    <option value="2">Trần Văn B</option>
                                    <option value="3">Lê Thị C</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="branchOpenDate" class="form-label">Ngày khai trương</label>
                                <input type="date" class="form-control" id="branchOpenDate" name="open_date" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">Thêm chi nhánh</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.branch-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.1rem;
}
.branch-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.branch-code {
    font-size: 0.8rem;
}
.branch-address {
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}
.branch-phone {
    font-size: 0.8rem;
}
.manager-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.manager-contact {
    font-size: 0.8rem;
}
.staff-count .fw-bold {
    font-size: 1.1rem;
}
.staff-status {
    font-size: 0.8rem;
}
.revenue {
    text-align: right;
}
.revenue-growth {
    font-size: 0.8rem;
    font-weight: 500;
}
.performance-bar .progress {
    border-radius: 3px;
}
.ranking-position .badge {
    width: 24px;
    height: 24px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
}
.ranking-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.ranking-metrics {
    font-size: 0.8rem;
}
.activity-icon {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}
.activity-text {
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}
.activity-time {
    font-size: 0.8rem;
}
</style>

<script>
// Branch Performance Chart
const branchCtx = document.getElementById("branchChart").getContext("2d");
const branchChart = new Chart(branchCtx, {
    type: "bar",
    data: {
        labels: ["CN Quận 1", "CN Quận 3", "CN Quận 7"],
        datasets: [{
            label: "Doanh thu (triệu đồng)",
            data: [55, 42, 28],
            backgroundColor: "rgba(74, 144, 226, 0.8)",
            borderColor: "#4a90e2",
            borderWidth: 1,
            yAxisID: "y"
        }, {
            label: "Hiệu suất (%)",
            data: [95, 82, 68],
            type: "line",
            backgroundColor: "rgba(85, 239, 196, 0.2)",
            borderColor: "#55efc4",
            borderWidth: 3,
            tension: 0.4,
            yAxisID: "y1"
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: "bottom"
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        if (context.datasetIndex === 0) {
                            return "Doanh thu: " + context.raw + " triệu đồng";
                        } else {
                            return "Hiệu suất: " + context.raw + "%";
                        }
                    }
                }
            }
        },
        scales: {
            y: {
                type: "linear",
                display: true,
                position: "left",
                beginAtZero: true,
                title: {
                    display: true,
                    text: "Doanh thu (triệu đồng)"
                }
            },
            y1: {
                type: "linear",
                display: true,
                position: "right",
                beginAtZero: true,
                max: 100,
                title: {
                    display: true,
                    text: "Hiệu suất (%)"
                },
                grid: {
                    drawOnChartArea: false,
                }
            }
        }
    }
});

// Branch actions
function viewBranch(id) {
    alert("Xem chi tiết chi nhánh ID: " + id);
}

function editBranch(id) {
    alert("Chỉnh sửa chi nhánh ID: " + id);
}

function viewReport(id) {
    alert("Xem báo cáo chi nhánh ID: " + id);
}

// Quick actions
function compareBranches() {
    alert("Tính năng so sánh chi nhánh sẽ được phát triển trong phiên bản tiếp theo");
}

function exportBranchReport() {
    alert("Tính năng xuất báo cáo sẽ được phát triển trong phiên bản tiếp theo");
}

function scheduleMeeting() {
    alert("Tính năng lên lịch họp sẽ được phát triển trong phiên bản tiếp theo");
}

function sendAlert() {
    alert("Tính năng gửi cảnh báo sẽ được phát triển trong phiên bản tiếp theo");
}

// Chart period change
document.querySelectorAll("input[name=\"chartPeriod\"]").forEach(radio => {
    radio.addEventListener("change", function() {
        console.log("Chart period changed to:", this.id);
        // Có thể thêm logic để tải lại dữ liệu theo period
    });
});

// Add branch form
document.getElementById("addBranchForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    fetch("/api/branches/create", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById("addBranchModal")).hide();
            location.reload();
        } else {
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        }
    })
    .catch(error => {
        console.error("Error:", error);
        alert("Có lỗi xảy ra. Vui lòng thử lại.");
    });
});

// Set default open date
document.getElementById("branchOpenDate").value = new Date().toISOString().split("T")[0];

// Auto-refresh mỗi 60 giây
setInterval(() => {
    if (!document.querySelector(".modal.show")) {
        location.reload();
    }
}, 60000);
</script>';

include 'layout.php';
?>