<?php
class Sale {
    private $conn;
    private $table_name = "sales";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function getSalesData($user_id, $role, $branch_id) {
        $data = [];
        
        // Doanh số hôm nay
        $query = "SELECT SUM(amount) as total FROM sales WHERE DATE(sale_date) = CURDATE()";
        if($role != 'owner') {
            $query .= " AND branch_id = :branch_id";
        }
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['todaySales'] = $row['total'] ? $row['total'] : 0;
        
        // Doanh số tháng này
        $query = "SELECT SUM(amount) as total FROM sales WHERE MONTH(sale_date) = MONTH(CURDATE()) AND YEAR(sale_date) = YEAR(CURDATE())";
        if($role != 'owner') {
            $query .= " AND branch_id = :branch_id";
        }
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['monthSales'] = $row['total'] ? $row['total'] : 0;
        
        // Doanh số theo loại
        $query = "SELECT type, SUM(amount) as total FROM sales WHERE DATE(sale_date) = CURDATE()";
        if($role != 'owner') {
            $query .= " AND branch_id = :branch_id";
        }
        $query .= " GROUP BY type";
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $data['salesByType'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Doanh số gần đây
        $query = "SELECT s.*, u.name as employee_name, b.name as branch_name 
                  FROM sales s 
                  JOIN users u ON s.user_id = u.id 
                  JOIN branches b ON s.branch_id = b.id 
                  WHERE 1=1";
        
        if($role != 'owner') {
            $query .= " AND s.branch_id = :branch_id";
        }
        
        $query .= " ORDER BY s.sale_date DESC LIMIT 10";
        
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $data['recentSales'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        return $data;
    }

    public function createSale($user_id, $branch_id, $type, $amount, $description, $sale_date = null) {
        if (!$sale_date) {
            $sale_date = date('Y-m-d H:i:s');
        }
        
        $query = "INSERT INTO sales (user_id, branch_id, type, amount, description, sale_date, created_at) 
                  VALUES (:user_id, :branch_id, :type, :amount, :description, :sale_date, NOW())";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':branch_id', $branch_id);
        $stmt->bindParam(':type', $type);
        $stmt->bindParam(':amount', $amount);
        $stmt->bindParam(':description', $description);
        $stmt->bindParam(':sale_date', $sale_date);
        
        return $stmt->execute();
    }
    
    public function getRecentSales($role, $branch_id, $limit = 10) {
        $query = "SELECT s.*, u.name as employee_name, b.name as branch_name 
                  FROM sales s 
                  JOIN users u ON s.user_id = u.id 
                  JOIN branches b ON s.branch_id = b.id 
                  WHERE 1=1";
        
        if($role != 'owner') {
            $query .= " AND s.branch_id = :branch_id";
        }
        
        $query .= " ORDER BY s.sale_date DESC LIMIT :limit";
        
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    public function getProductSalesData($user_id, $role, $branch_id) {
        $data = [];
        
        // Doanh số sản phẩm hôm nay
        $query = "SELECT SUM(amount) as total FROM sales 
                  WHERE DATE(sale_date) = CURDATE() AND type = 'product'";
        if($role != 'owner') {
            $query .= " AND branch_id = :branch_id";
        }
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['todayProductSales'] = $row['total'] ? $row['total'] : 0;
        
        // Doanh số sản phẩm tháng này
        $query = "SELECT SUM(amount) as total FROM sales 
                  WHERE MONTH(sale_date) = MONTH(CURDATE()) AND YEAR(sale_date) = YEAR(CURDATE()) 
                  AND type = 'product'";
        if($role != 'owner') {
            $query .= " AND branch_id = :branch_id";
        }
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['monthProductSales'] = $row['total'] ? $row['total'] : 0;
        
        return $data;
    }
    
    public function getServiceSalesData($user_id, $role, $branch_id) {
        $data = [];
        
        // Doanh số dịch vụ hôm nay
        $query = "SELECT SUM(amount) as total FROM sales 
                  WHERE DATE(sale_date) = CURDATE() AND type = 'service'";
        if($role != 'owner') {
            $query .= " AND branch_id = :branch_id";
        }
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['todayServiceSales'] = $row['total'] ? $row['total'] : 0;
        
        // Doanh số dịch vụ tháng này
        $query = "SELECT SUM(amount) as total FROM sales 
                  WHERE MONTH(sale_date) = MONTH(CURDATE()) AND YEAR(sale_date) = YEAR(CURDATE()) 
                  AND type = 'service'";
        if($role != 'owner') {
            $query .= " AND branch_id = :branch_id";
        }
        $stmt = $this->conn->prepare($query);
        if($role != 'owner') {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['monthServiceSales'] = $row['total'] ? $row['total'] : 0;
        
        return $data;
    }
}
?>