<?php
class Kpi {
    private $conn;
    private $table_name = "kpi_targets";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function getUserKpi($user_id) {
        $currentMonth = date('Y-m');
        
        $query = "SELECT target_type, target_value 
                  FROM kpi_targets 
                  WHERE user_id = :user_id AND month_year = :month
                  ORDER BY created_at DESC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':month', $currentMonth);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getKpiProgress($user_id) {
        $currentMonth = date('Y-m');
        $progress = [];
        
        // Doanh số dịch vụ
        $serviceProgress = $this->calculateServiceProgress($user_id, $currentMonth);
        if ($serviceProgress) {
            $progress[] = $serviceProgress;
        }
        
        // Doanh số sản phẩm
        $productProgress = $this->calculateProductProgress($user_id, $currentMonth);
        if ($productProgress) {
            $progress[] = $productProgress;
        }
        
        return $progress;
    }
    
    private function calculateServiceProgress($user_id, $month) {
        $query = "SELECT target_value FROM kpi_targets 
                  WHERE user_id = :user_id AND month_year = :month AND target_type = 'service_sales'";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':month', $month);
        $stmt->execute();
        $target = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$target) return null;
        
        $query = "SELECT COALESCE(SUM(amount), 0) as achieved FROM sales 
                  WHERE user_id = :user_id AND DATE_FORMAT(sale_date, '%Y-%m') = :month 
                  AND type = 'service'";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':month', $month);
        $stmt->execute();
        $achieved = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $percentage = $target['target_value'] > 0 ? 
            min(100, round(($achieved['achieved'] / $target['target_value']) * 100)) : 0;
            
        return [
            'name' => 'Doanh số dịch vụ',
            'target' => $target['target_value'],
            'achieved' => $achieved['achieved'],
            'percentage' => $percentage
        ];
    }
    
    private function calculateProductProgress($user_id, $month) {
        // Tương tự như service progress
        $query = "SELECT target_value FROM kpi_targets 
                  WHERE user_id = :user_id AND month_year = :month AND target_type = 'product_sales'";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':month', $month);
        $stmt->execute();
        $target = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$target) return null;
        
        $query = "SELECT COALESCE(SUM(amount), 0) as achieved FROM sales 
                  WHERE user_id = :user_id AND DATE_FORMAT(sale_date, '%Y-%m') = :month 
                  AND type = 'product'";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':month', $month);
        $stmt->execute();
        $achieved = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $percentage = $target['target_value'] > 0 ? 
            min(100, round(($achieved['achieved'] / $target['target_value']) * 100)) : 0;
            
        return [
            'name' => 'Doanh số sản phẩm',
            'target' => $target['target_value'],
            'achieved' => $achieved['achieved'],
            'percentage' => $percentage
        ];
    }
}
?>