<?php
class TaskController extends Controller {
    public function index() {
        // Kiểm tra đăng nhập
        if(!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }
        
        $taskModel = $this->model('Task');
        $tasks = $taskModel->getUserTasks($_SESSION['user_id'], $_SESSION['branch_id']);
        
        $this->view('tasks', ['tasks' => $tasks]);
    }
    
    public function complete() {
        header('Content-Type: application/json');
        
        if(!isset($_SESSION['user_id'])) {
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $input = json_decode(file_get_contents('php://input'), true);
            $taskId = $input['task_id'] ?? '';
            $completed = $input['completed'] ?? false;
            
            $taskModel = $this->model('Task');
            
            if ($completed) {
                $result = $taskModel->completeTask($taskId, $_SESSION['user_id']);
            } else {
                $result = $taskModel->uncompleteTask($taskId, $_SESSION['user_id']);
            }
            
            echo json_encode(['success' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid method']);
        }
        exit();
    }
    
    public function delete() {
        header('Content-Type: application/json');
        
        if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] == 'employee') {
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $input = json_decode(file_get_contents('php://input'), true);
            $taskId = $input['task_id'] ?? '';
            
            $taskModel = $this->model('Task');
            $result = $taskModel->deleteTask($taskId);
            
            echo json_encode(['success' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid method']);
        }
        exit();
    }
    
    public function create() {
        // Kiểm tra quyền (chỉ manager và owner)
        if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] == 'employee') {
            header('Location: /tasks');
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $title = $_POST['title'] ?? '';
            $description = $_POST['description'] ?? '';
            
            $taskModel = $this->model('Task');
            $result = $taskModel->createTask($title, $description, $_SESSION['branch_id'], $_SESSION['user_id']);
            
            if ($result) {
                header('Location: /tasks?success=1');
            } else {
                header('Location: /tasks?error=1');
            }
            exit();
        }
    }
}
?>