<?php
class DashboardController extends Controller {
    public function index() {
        $this->checkAuth();
        
        // Lấy dữ liệu thực từ database
        $saleModel = $this->model('Sale');
        $taskModel = $this->model('Task');
        $kpiModel = $this->model('Kpi');
        
        // Doanh số hôm nay
        $salesData = $saleModel->getSalesData($_SESSION['user_id'], $_SESSION['user_role'], $_SESSION['branch_id']);
        $todaySales = $salesData['todaySales'] ?? 0;
        
        // Nhiệm vụ
        $tasks = $taskModel->getUserTasks($_SESSION['user_id'], $_SESSION['branch_id']);
        $completedTasks = count(array_filter($tasks, function($task) { return $task['completed']; }));
        $totalTasks = count($tasks);
        
        // KPI
        $kpiProgress = $kpiModel->getKpiProgress($_SESSION['user_id']);
        $avgKpiProgress = !empty($kpiProgress) ? array_sum(array_column($kpiProgress, 'percentage')) / count($kpiProgress) : 0;
        
        // Nhân viên đang làm việc (giả lập)
        $activeEmployees = 6;
        
        // Lấy 4 nhiệm vụ gần nhất
        $dailyTasks = array_slice($tasks, 0, 4);
        
        // Lấy giao dịch gần đây
        $recentSales = $saleModel->getRecentSales($_SESSION['user_role'], $_SESSION['branch_id'], 5);
        
        $data = [
            'todaySales' => $todaySales,
            'completedTasks' => $completedTasks,
            'totalTasks' => $totalTasks,
            'kpiProgress' => round($avgKpiProgress),
            'activeEmployees' => $activeEmployees,
            'dailyTasks' => $dailyTasks,
            'kpiItems' => $kpiProgress,
            'recentSales' => $recentSales
        ];
        
        $this->view('dashboard', $data);
    }
}
?>