<?php
class BranchController extends Controller {
    public function index() {
        // Chỉ owner và manager được truy cập
        if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] == 'employee') {
            header('Location: /dashboard');
            exit();
        }
        
        $branchModel = $this->model('Branch');
        
        if ($_SESSION['user_role'] == 'owner') {
            $branches = $branchModel->getAllBranches();
        } else {
            $branches = $branchModel->getBranchById($_SESSION['branch_id']);
        }
        
        $this->view('branches', ['branches' => $branches]);
    }
    
    public function create() {
        header('Content-Type: application/json');
        
        if(!isset($_SESSION['user_id']) || $_SESSION['user_role'] != 'owner') {
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $input = json_decode(file_get_contents('php://input'), true);
            
            $name = $input['name'] ?? '';
            $code = $input['code'] ?? '';
            $address = $input['address'] ?? '';
            $phone = $input['phone'] ?? '';
            $email = $input['email'] ?? '';
            $managerId = $input['manager_id'] ?? '';
            
            $branchModel = $this->model('Branch');
            $result = $branchModel->createBranch($name, $code, $address, $phone, $email, $managerId);
            
            echo json_encode(['success' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid method']);
        }
        exit();
    }
}
?>