<?php
$canEditSettings = in_array('edit_system_settings', $userPermissions);
$canManagePermissions = in_array('manage_user_permissions', $userPermissions);
$canBackup = in_array('backup_system', $userPermissions);
$canMaintenance = in_array('system_maintenance', $userPermissions);
$canViewLogs = in_array('view_system_logs', $userPermissions);

$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Cài đặt hệ thống</h1>
            <p class="page-subtitle text-muted">Quản lý cấu hình, phân quyền và bảo trì hệ thống</p>
        </div>
        <div class="col-auto">
            <?php if ($canBackup): ?>
            <button class="btn btn-success me-2" onclick="createBackup()">
                <i class="fas fa-download me-2"></i>Sao lưu hệ thống
            </button>
            <?php endif; ?>
            <?php if ($canMaintenance): ?>
            <button class="btn btn-warning" onclick="clearCache()">
                <i class="fas fa-broom me-2"></i>Xóa cache
            </button>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Settings Navigation -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body p-0">
                <nav class="nav nav-pills nav-fill settings-nav">
                    <a class="nav-link active" data-bs-toggle="tab" href="#general-settings">
                        <i class="fas fa-cog me-2"></i>Cài đặt chung
                    </a>
                    <a class="nav-link" data-bs-toggle="tab" href="#kpi-settings">
                        <i class="fas fa-chart-line me-2"></i>Cài đặt KPI
                    </a>
                    <a class="nav-link" data-bs-toggle="tab" href="#security-settings">
                        <i class="fas fa-shield-alt me-2"></i>Bảo mật
                    </a>
                    <?php if ($canManagePermissions): ?>
                    <a class="nav-link" data-bs-toggle="tab" href="#permissions">
                        <i class="fas fa-users-cog me-2"></i>Phân quyền
                    </a>
                    <?php endif; ?>
                    <a class="nav-link" data-bs-toggle="tab" href="#system-info">
                        <i class="fas fa-info-circle me-2"></i>Thông tin hệ thống
                    </a>
                    <?php if ($canViewLogs): ?>
                    <a class="nav-link" data-bs-toggle="tab" href="#audit-logs">
                        <i class="fas fa-history me-2"></i>Nhật ký hệ thống
                    </a>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </div>
</div>

<!-- Settings Content -->
<div class="tab-content">
    <!-- General Settings Tab -->
    <div class="tab-pane fade show active" id="general-settings">
        <div class="row">
            <div class="col-xl-8 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Cài đặt chung</h5>
                    </div>
                    <div class="card-body">
                        <form id="systemSettingsForm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="systemName" class="form-label">Tên hệ thống</label>
                                        <input type="text" class="form-control" id="systemName" name="system_name" 
                                               value="' . htmlspecialchars($settings['system_name']['value'] ?? 'Spa KPI Management System') . '"
                                               ' . (!$canEditSettings ? 'readonly' : '') . '>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="systemVersion" class="form-label">Phiên bản</label>
                                        <input type="text" class="form-control" id="systemVersion" 
                                               value="' . htmlspecialchars($settings['system_version']['value'] ?? '1.0.0') . '" readonly>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="timezone" class="form-label">Múi giờ</label>
                                        <select class="form-select" id="timezone" name="timezone" ' . (!$canEditSettings ? 'disabled' : '') . '>
                                            <option value="Asia/Ho_Chi_Minh">Việt Nam (UTC+7)</option>
                                            <option value="Asia/Bangkok">Thái Lan (UTC+7)</option>
                                            <option value="Asia/Singapore">Singapore (UTC+8)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="currency" class="form-label">Đơn vị tiền tệ</label>
                                        <select class="form-select" id="currency" name="currency" ' . (!$canEditSettings ? 'disabled' : '') . '>
                                            <option value="VND">Việt Nam Đồng (VND)</option>
                                            <option value="USD">US Dollar (USD)</option>
                                            <option value="EUR">Euro (EUR)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Giờ làm việc</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="time" class="form-control" id="startTime" name="working_hours_start" 
                                               value="' . ($settings['working_hours_start']['value'] ?? '08:00') . '"
                                               ' . (!$canEditSettings ? 'readonly' : '') . '>
                                        <small class="text-muted">Giờ bắt đầu</small>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="time" class="form-control" id="endTime" name="working_hours_end" 
                                               value="' . ($settings['working_hours_end']['value'] ?? '22:00') . '"
                                               ' . (!$canEditSettings ? 'readonly' : '') . '>
                                        <small class="text-muted">Giờ kết thúc</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="autoRefresh" name="auto_refresh" 
                                           ' . (($settings['auto_refresh']['value'] ?? '1') == '1' ? 'checked' : '') . '
                                           ' . (!$canEditSettings ? 'disabled' : '') . '>
                                    <label class="form-check-label" for="autoRefresh">
                                        Tự động làm mới dữ liệu
                                    </label>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="notifications" name="notifications_enabled" 
                                           ' . (($settings['notifications_enabled']['value'] ?? '1') == '1' ? 'checked' : '') . '
                                           ' . (!$canEditSettings ? 'disabled' : '') . '>
                                    <label class="form-check-label" for="notifications">
                                        Bật thông báo hệ thống
                                    </label>
                                </div>
                            </div>
                            
                            <?php if ($canEditSettings): ?>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Lưu cài đặt
                            </button>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-4 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Email Settings</h5>
                    </div>
                    <div class="card-body">
                        <form id="emailSettingsForm">
                            <div class="mb-3">
                                <label for="smtpHost" class="form-label">SMTP Host</label>
                                <input type="text" class="form-control" id="smtpHost" name="smtp_host" 
                                       value="' . htmlspecialchars($settings['smtp_host']['value'] ?? '') . '"
                                       ' . (!$canEditSettings ? 'readonly' : '') . '>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="smtpPort" class="form-label">Port</label>
                                        <input type="number" class="form-control" id="smtpPort" name="smtp_port" 
                                               value="' . ($settings['smtp_port']['value'] ?? '587') . '"
                                               ' . (!$canEditSettings ? 'readonly' : '') . '>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="smtpEncryption" class="form-label">Mã hóa</label>
                                        <select class="form-select" id="smtpEncryption" name="smtp_encryption" ' . (!$canEditSettings ? 'disabled' : '') . '>
                                            <option value="tls">TLS</option>
                                            <option value="ssl">SSL</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="smtpUsername" class="form-label">Username</label>
                                <input type="text" class="form-control" id="smtpUsername" name="smtp_username" 
                                       value="' . htmlspecialchars($settings['smtp_username']['value'] ?? '') . '"
                                       ' . (!$canEditSettings ? 'readonly' : '') . '>
                            </div>
                            <div class="mb-3">
                                <label for="smtpPassword" class="form-label">Password</label>
                                <input type="password" class="form-control" id="smtpPassword" name="smtp_password" 
                                       value="' . str_repeat('*', strlen($settings['smtp_password']['value'] ?? '')) . '"
                                       ' . (!$canEditSettings ? 'readonly' : '') . '>
                            </div>
                            <?php if ($canEditSettings): ?>
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-envelope me-2"></i>Lưu cài đặt Email
                            </button>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- KPI Settings Tab -->
    <div class="tab-pane fade" id="kpi-settings">
        <div class="row">
            <div class="col-xl-8 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Cài đặt KPI</h5>
                    </div>
                    <div class="card-body">
                        <form id="kpiSettingsForm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="defaultServiceTarget" class="form-label">Mục tiêu doanh số dịch vụ mặc định</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="defaultServiceTarget" name="default_service_target" 
                                                   value="' . ($settings['default_service_target']['value'] ?? '50000000') . '"
                                                   ' . (!$canEditSettings ? 'readonly' : '') . '>
                                            <span class="input-group-text">đ</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="defaultProductTarget" class="form-label">Mục tiêu doanh số sản phẩm mặc định</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="defaultProductTarget" name="default_product_target" 
                                                   value="' . ($settings['default_product_target']['value'] ?? '20000000') . '"
                                                   ' . (!$canEditSettings ? 'readonly' : '') . '>
                                            <span class="input-group-text">đ</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="kpiUpdateFrequency" class="form-label">Tần suất cập nhật KPI</label>
                                        <select class="form-select" id="kpiUpdateFrequency" name="kpi_update_frequency" ' . (!$canEditSettings ? 'disabled' : '') . '>
                                            <option value="realtime">Thời gian thực</option>
                                            <option value="hourly">Mỗi giờ</option>
                                            <option value="daily">Hàng ngày</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="performanceThreshold" class="form-label">Ngưỡng hiệu suất tốt</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="performanceThreshold" name="performance_threshold" 
                                                   value="' . ($settings['performance_threshold']['value'] ?? '80') . '" min="0" max="100"
                                                   ' . (!$canEditSettings ? 'readonly' : '') . '>
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="kpiReportFrequency" class="form-label">Tần suất báo cáo KPI</label>
                                        <select class="form-select" id="kpiReportFrequency" name="kpi_report_frequency" ' . (!$canEditSettings ? 'disabled' : '') . '>
                                            <option value="daily">Hàng ngày</option>
                                            <option value="weekly">Hàng tuần</option>
                                            <option value="monthly">Hàng tháng</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="kpiNotificationThreshold" class="form-label">Ngưỡng cảnh báo KPI</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="kpiNotificationThreshold" name="kpi_notification_threshold" 
                                                   value="50" min="0" max="100" ' . (!$canEditSettings ? 'readonly' : '') . '>
                                            <span class="input-group-text">%</span>
                                        </div>
                                        <small class="text-muted">Gửi cảnh báo khi KPI dưới ngưỡng này</small>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if ($canEditSettings): ?>
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-chart-line me-2"></i>Lưu cài đặt KPI
                            </button>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-4 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">KPI Templates</h5>
                    </div>
                    <div class="card-body">
                        <div class="kpi-templates">
                            <div class="template-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <div class="template-name">Nhân viên Massage</div>
                                        <div class="template-desc text-muted small">Dịch vụ: 40M, Sản phẩm: 15M</div>
                                    </div>
                                    <button class="btn btn-sm btn-outline-primary" onclick="applyTemplate(1)">Áp dụng</button>
                                </div>
                            </div>
                            
                            <div class="template-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <div class="template-name">Nhân viên Skincare</div>
                                        <div class="template-desc text-muted small">Dịch vụ: 35M, Sản phẩm: 20M</div>
                                    </div>
                                    <button class="btn btn-sm btn-outline-primary" onclick="applyTemplate(2)">Áp dụng</button>
                                </div>
                            </div>
                            
                            <div class="template-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <div class="template-name">Nhân viên Sales</div>
                                        <div class="template-desc text-muted small">Dịch vụ: 25M, Sản phẩm: 30M</div>
                                    </div>
                                    <button class="btn btn-sm btn-outline-primary" onclick="applyTemplate(3)">Áp dụng</button>
                                </div>
                            </div>
                        </div>
                        
                        <?php if ($canEditSettings): ?>
                        <button class="btn btn-primary btn-sm w-100" onclick="createKpiTemplate()">
                            <i class="fas fa-plus me-2"></i>Tạo template mới
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Security Settings Tab -->
    <div class="tab-pane fade" id="security-settings">
        <div class="row">
            <div class="col-xl-8 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Cài đặt bảo mật</h5>
                    </div>
                    <div class="card-body">
                        <form id="securitySettingsForm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sessionTimeout" class="form-label">Thời gian hết phiên</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="sessionTimeout" name="session_timeout" 
                                                   value="' . ($settings['session_timeout']['value'] ?? '60') . '" min="15" max="480"
                                                   ' . (!$canEditSettings ? 'readonly' : '') . '>
                                            <span class="input-group-text">phút</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="maxLoginAttempts" class="form-label">Số lần đăng nhập tối đa</label>
                                        <input type="number" class="form-control" id="maxLoginAttempts" name="max_login_attempts" 
                                               value="' . ($settings['max_login_attempts']['value'] ?? '5') . '" min="3" max="10"
                                               ' . (!$canEditSettings ? 'readonly' : '') . '>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="passwordMinLength" class="form-label">Độ dài mật khẩu tối thiểu</label>
                                        <input type="number" class="form-control" id="passwordMinLength" name="password_min_length" 
                                               value="8" min="6" max="20" ' . (!$canEditSettings ? 'readonly' : '') . '>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="passwordExpiry" class="form-label">Thời hạn mật khẩu</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="passwordExpiry" name="password_expiry" 
                                                   value="90" min="30" max="365" ' . (!$canEditSettings ? 'readonly' : '') . '>
                                            <span class="input-group-text">ngày</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="twoFactorAuth" name="two_factor_auth"
                                           ' . (($settings['two_factor_auth']['value'] ?? '0') == '1' ? 'checked' : '') . '
                                           ' . (!$canEditSettings ? 'disabled' : '') . '>
                                    <label class="form-check-label" for="twoFactorAuth">
                                        Xác thực 2 yếu tố (2FA)
                                    </label>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="auditLog" name="audit_log"
                                           ' . (($settings['audit_log']['value'] ?? '1') == '1' ? 'checked' : '') . '
                                           ' . (!$canEditSettings ? 'disabled' : '') . '>
                                    <label class="form-check-label" for="auditLog">
                                        Ghi nhật ký hoạt động
                                    </label>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="forceHttps" name="force_https"
                                           ' . (!$canEditSettings ? 'disabled' : '') . '>
                                    <label class="form-check-label" for="forceHttps">
                                        Bắt buộc HTTPS
                                    </label>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="ipWhitelist" name="ip_whitelist_enabled"
                                           ' . (!$canEditSettings ? 'disabled' : '') . '>
                                    <label class="form-check-label" for="ipWhitelist">
                                        Bật whitelist IP
                                    </label>
                                </div>
                            </div>
                            
                            <?php if ($canEditSettings): ?>
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-shield-alt me-2"></i>Lưu cài đặt bảo mật
                            </button>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-4 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Trạng thái bảo mật</h5>
                    </div>
                    <div class="card-body">
                        <div class="security-status">
                            <div class="status-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="status-label">HTTPS</span>
                                    <span class="badge bg-' . (isset($_SERVER['HTTPS']) ? 'success' : 'warning') . '">
                                        ' . (isset($_SERVER['HTTPS']) ? 'Bật' : 'Tắt') . '
                                    </span>
                                </div>
                            </div>
                            
                            <div class="status-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="status-label">2FA</span>
                                    <span class="badge bg-' . (($settings['two_factor_auth']['value'] ?? '0') == '1' ? 'success' : 'secondary') . '">
                                        ' . (($settings['two_factor_auth']['value'] ?? '0') == '1' ? 'Bật' : 'Tắt') . '
                                    </span>
                                </div>
                            </div>
                            
                            <div class="status-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="status-label">Audit Log</span>
                                    <span class="badge bg-' . (($settings['audit_log']['value'] ?? '1') == '1' ? 'success' : 'secondary') . '">
                                        ' . (($settings['audit_log']['value'] ?? '1') == '1' ? 'Bật' : 'Tắt') . '
                                    </span>
                                </div>
                            </div>
                            
                            <div class="status-item mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="status-label">Session Timeout</span>
                                    <span class="badge bg-info">' . ($settings['session_timeout']['value'] ?? '60') . ' phút</span>
                                </div>
                            </div>
                        </div>
                        
                        <?php if ($canMaintenance): ?>
                        <div class="security-actions mt-3">
                            <div class="d-grid gap-2">
                                <button class="btn btn-warning btn-sm" onclick="resetFailedLogins()">
                                    <i class="fas fa-unlock me-2"></i>Reset failed logins
                                </button>
                                <button class="btn btn-info btn-sm" onclick="viewSecurityLogs()">
                                    <i class="fas fa-eye me-2"></i>Xem log bảo mật
                                </button>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Permissions Management Tab -->
    <?php if ($canManagePermissions): ?>
    <div class="tab-pane fade" id="permissions">
        <div class="row">
            <div class="col-xl-8 mb-4">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Quản lý phân quyền người dùng</h5>
                        <div class="user-filter">
                            <select class="form-select form-select-sm" id="userFilter" onchange="filterUsers()">
                                <option value="all">Tất cả người dùng</option>
                                <option value="owner">Chủ spa</option>
                                <option value="manager">Quản lý</option>
                                <option value="team_leader">Trưởng nhóm</option>
                                <option value="employee">Nhân viên</option>
                            </select>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Người dùng</th>
                                        <th>Chức vụ</th>
                                        <th>Chi nhánh</th>
                                        <th>Quyền custom</th>
                                        <th>Thao tác</th>
                                    </tr>
                                </thead>
                                <tbody id="usersTableBody">';

if (!empty($users)) {
    foreach($users as $user) {
        $content .= '
                                    <tr class="user-row" data-role="' . $user['role'] . '">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="user-avatar me-3">
                                                    ' . strtoupper(substr($user['name'], 0, 1)) . '
                                                </div>
                                                <div>
                                                    <div class="user-name">' . htmlspecialchars($user['name']) . '</div>
                                                    <div class="user-email text-muted small">' . htmlspecialchars($user['email']) . '</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-' . ($user['role'] == 'owner' ? 'danger' : ($user['role'] == 'manager' ? 'primary' : 'secondary')) . '">
                                                ' . ucfirst($user['role']) . '
                                            </span>
                                        </td>
                                        <td>' . htmlspecialchars($user['branch_name'] ?? 'N/A') . '</td>
                                        <td>
                                            <span class="badge bg-info custom-permissions-count" data-user-id="' . $user['id'] . '">0</span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary" onclick="editUserPermissions(' . $user['id'] . ', \'' . htmlspecialchars($user['name']) . '\')"
                                                    ' . ($user['id'] == $_SESSION['user_id'] ? 'disabled title="Không thể sửa quyền của chính mình"' : '') . '>
                                                <i class="fas fa-edit"></i> Sửa quyền
                                            </button>
                                        </td>
                                    </tr>';
    }
}

$content .= '
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-4 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Quyền theo chức vụ</h5>
                    </div>
                    <div class="card-body">
                        <div class="role-permissions">
                            <div class="accordion" id="rolePermissionsAccordion">
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ownerPermissions">
                                            <i class="fas fa-crown me-2 text-danger"></i>Chủ spa (Owner)
                                        </button>
                                    </h2>
                                    <div id="ownerPermissions" class="accordion-collapse collapse" data-bs-parent="#rolePermissionsAccordion">
                                        <div class="accordion-body">
                                            <small class="text-success">✓ Toàn quyền hệ thống</small>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#managerPermissions">
                                            <i class="fas fa-user-tie me-2 text-primary"></i>Quản lý (Manager)
                                        </button>
                                    </h2>
                                    <div id="managerPermissions" class="accordion-collapse collapse" data-bs-parent="#rolePermissionsAccordion">
                                        <div class="accordion-body">
                                            <div class="permission-list">
                                                <small class="text-success d-block">✓ Quản lý chi nhánh</small>
                                                <small class="text-success d-block">✓ Quản lý nhân viên</small>
                                                <small class="text-success d-block">✓ Xem báo cáo</small>
                                                <small class="text-success d-block">✓ Quản lý KPI team</small>
                                                <small class="text-muted d-block">✗ Cài đặt hệ thống</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#employeePermissions">
                                            <i class="fas fa-user me-2 text-secondary"></i>Nhân viên (Employee)
                                        </button>
                                    </h2>
                                    <div id="employeePermissions" class="accordion-collapse collapse" data-bs-parent="#rolePermissionsAccordion">
                                        <div class="accordion-body">
                                            <div class="permission-list">
                                                <small class="text-success d-block">✓ Xem dashboard</small>
                                                <small class="text-success d-block">✓ Quản lý nhiệm vụ cá nhân</small>
                                                <small class="text-success d-block">✓ Xem KPI cá nhân</small>
                                                <small class="text-success d-block">✓ Nhập doanh số</small>
                                                <small class="text-muted d-block">✗ Quản lý nhân viên</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">Thống kê phân quyền</h5>
                    </div>
                    <div class="card-body">
                        <div class="permission-stats">
                            <div class="stat-item mb-2">
                                <div class="d-flex justify-content-between">
                                    <span>Tổng người dùng:</span>
                                    <span class="fw-bold">' . count($users) . '</span>
                                </div>
                            </div>
                            <div class="stat-item mb-2">
                                <div class="d-flex justify-content-between">
                                    <span>Có quyền custom:</span>
                                    <span class="fw-bold text-info" id="customPermissionCount">0</span>
                                </div>
                            </div>
                            <div class="stat-item mb-2">
                                <div class="d-flex justify-content-between">
                                    <span>Hoạt động:</span>
                                    <span class="fw-bold text-success">' . count(array_filter($users, function($u) { return $u['is_active']; })) . '</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- System Information Tab -->
    <div class="tab-pane fade" id="system-info">
        <div class="row">
            <div class="col-xl-8 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Thông tin hệ thống</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="system-info">
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Phiên bản hệ thống:</span>
                                            <span class="info-value fw-bold">' . ($settings['system_version']['value'] ?? '1.0.0') . '</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Phiên bản PHP:</span>
                                            <span class="info-value">' . phpversion() . '</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Cơ sở dữ liệu:</span>
                                            <span class="info-value">MySQL 8.0</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Web Server:</span>
                                            <span class="info-value">' . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . '</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="system-info">
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Thời gian hoạt động:</span>
                                            <span class="info-value" id="uptime">15 ngày 8 giờ</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Dung lượng đĩa trống:</span>
                                            <span class="info-value">50 GB</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Bộ nhớ sử dụng:</span>
                                            <span class="info-value">128 MB</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="info-label">Múi giờ:</span>
                                            <span class="info-value">' . ($settings['timezone']['value'] ?? 'Asia/Ho_Chi_Minh') . '</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="system-metric">
                                        <div class="metric-value text-primary">' . count($users) . '</div>
                                        <div class="metric-label">Người dùng</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="system-metric">
                                        <div class="metric-value text-success">3</div>
                                        <div class="metric-label">Chi nhánh</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="system-metric">
                                        <div class="metric-value text-warning">8</div>
                                        <div class="metric-label">Phòng ban</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="system-metric">
                                        <div class="metric-value text-info">156</div>
                                        <div class="metric-label">Nhiệm vụ</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-4 mb-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Thao tác hệ thống</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <?php if ($canMaintenance): ?>
                            <button class="btn btn-info btn-sm" onclick="clearCache()">
                                <i class="fas fa-broom me-2"></i>Xóa cache hệ thống
                            </button>
                            <?php endif; ?>
                            
                            <?php if ($canBackup): ?>
                            <button class="btn btn-warning btn-sm" onclick="createBackup()">
                                <i class="fas fa-database me-2"></i>Sao lưu cơ sở dữ liệu
                            </button>
                            <?php endif; ?>
                            
                            <button class="btn btn-success btn-sm" onclick="exportSystemData()">
                                <i class="fas fa-download me-2"></i>Xuất dữ liệu hệ thống
                            </button>
                            
                            <?php if ($canViewLogs): ?>
                            <button class="btn btn-secondary btn-sm" onclick="viewSystemLogs()">
                                <i class="fas fa-file-alt me-2"></i>Xem nhật ký hệ thống
                            </button>
                            <?php endif; ?>
                            
                            <button class="btn btn-primary btn-sm" onclick="checkSystemHealth()">
                                <i class="fas fa-heartbeat me-2"></i>Kiểm tra sức khỏe hệ thống
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">Cập nhật hệ thống</h5>
                    </div>
                    <div class="card-body">
                        <div class="update-info">
                            <div class="current-version mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Phiên bản hiện tại:</span>
                                    <span class="fw-bold">' . ($settings['system_version']['value'] ?? '1.0.0') . '</span>
                                </div>
                            </div>
                            
                            <div class="latest-version mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Phiên bản mới nhất:</span>
                                    <span class="fw-bold text-success">1.0.0</span>
                                </div>
                            </div>
                            
                            <div class="update-status">
                                <div class="alert alert-success" role="alert">
                                    <i class="fas fa-check-circle me-2"></i>
                                    Hệ thống đã được cập nhật lên phiên bản mới nhất
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Audit Logs Tab -->
    <?php if ($canViewLogs): ?>
    <div class="tab-pane fade" id="audit-logs">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Nhật ký hoạt động hệ thống</h5>
                        <div class="log-controls">
                            <div class="input-group input-group-sm">
                                <select class="form-select" id="logFilter">
                                    <option value="all">Tất cả hoạt động</option>
                                    <option value="login">Đăng nhập</option>
                                    <option value="create">Tạo mới</option>
                                    <option value="update">Cập nhật</option>
                                    <option value="delete">Xóa</option>
                                    <option value="settings">Cài đặt</option>
                                </select>
                                <button class="btn btn-outline-secondary" onclick="refreshLogs()">
                                    <i class="fas fa-sync-alt"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Thời gian</th>
                                        <th>Người dùng</th>
                                        <th>Hành động</th>
                                        <th>Đối tượng</th>
                                        <th>IP Address</th>
                                        <th>Chi tiết</th>
                                    </tr>
                                </thead>
                                <tbody id="auditLogsTableBody">
                                    <!-- Logs sẽ được load bằng JavaScript -->
                                    <tr>
                                        <td colspan="6" class="text-center py-4">
                                            <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                                            Đang tải nhật ký...
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- User Permissions Modal -->
<div class="modal fade" id="userPermissionsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Chỉnh sửa quyền người dùng</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="user-info mb-3">
                    <div class="d-flex align-items-center">
                        <div class="user-avatar me-3" id="modalUserAvatar">U</div>
                        <div>
                            <div class="user-name fw-bold" id="modalUserName">User Name</div>
                            <div class="user-role text-muted" id="modalUserRole">Role</div>
                        </div>
                    </div>
                </div>
                
                <div class="permissions-grid">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Dashboard & Reports</h6>
                            <div class="permission-group mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_view_dashboard" value="view_dashboard">
                                    <label class="form-check-label" for="perm_view_dashboard">Xem dashboard</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_view_reports" value="view_reports">
                                    <label class="form-check-label" for="perm_view_reports">Xem báo cáo</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_export_reports" value="export_reports">
                                    <label class="form-check-label" for="perm_export_reports">Xuất báo cáo</label>
                                </div>
                            </div>
                            
                            <h6>Tasks Management</h6>
                            <div class="permission-group mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_view_tasks" value="view_tasks">
                                    <label class="form-check-label" for="perm_view_tasks">Xem nhiệm vụ</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_create_tasks" value="create_tasks">
                                    <label class="form-check-label" for="perm_create_tasks">Tạo nhiệm vụ</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_edit_tasks" value="edit_tasks">
                                    <label class="form-check-label" for="perm_edit_tasks">Sửa nhiệm vụ</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_delete_tasks" value="delete_tasks">
                                    <label class="form-check-label" for="perm_delete_tasks">Xóa nhiệm vụ</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <h6>Sales Management</h6>
                            <div class="permission-group mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_view_sales" value="view_sales">
                                    <label class="form-check-label" for="perm_view_sales">Xem doanh số</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_create_sales" value="create_sales">
                                    <label class="form-check-label" for="perm_create_sales">Thêm doanh số</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_edit_sales" value="edit_sales">
                                    <label class="form-check-label" for="perm_edit_sales">Sửa doanh số</label>
                                </div>
                            </div>
                            
                            <h6>System Settings</h6>
                            <div class="permission-group mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_edit_system_settings" value="edit_system_settings">
                                    <label class="form-check-label" for="perm_edit_system_settings">Sửa cài đặt hệ thống</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_manage_user_permissions" value="manage_user_permissions">
                                    <label class="form-check-label" for="perm_manage_user_permissions">Quản lý phân quyền</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_backup_system" value="backup_system">
                                    <label class="form-check-label" for="perm_backup_system">Sao lưu hệ thống</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="perm_view_system_logs" value="view_system_logs">
                                    <label class="form-check-label" for="perm_view_system_logs">Xem nhật ký hệ thống</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                <button type="button" class="btn btn-primary" onclick="saveUserPermissions()">Lưu thay đổi</button>
            </div>
        </div>
    </div>
</div>

<style>
.settings-nav .nav-link {
    border-radius: 0;
    border: none;
    padding: 1rem 1.5rem;
    color: #6c757d;
    font-weight: 500;
}

.settings-nav .nav-link.active {
    background-color: #0d6efd;
    color: white;
}

.settings-nav .nav-link:hover {
    background-color: #f8f9fa;
    color: #0d6efd;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 14px;
}

.system-metric {
    padding: 1rem;
    border-radius: 8px;
    background: #f8f9fa;
}

.metric-value {
    font-size: 2rem;
    font-weight: bold;
    margin-bottom: 0.5rem;
}

.metric-label {
    font-size: 0.875rem;
    color: #6c757d;
    font-weight: 500;
}

.info-item {
    padding: 0.75rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.info-item:last-child {
    border-bottom: none;
}

.info-label {
    font-weight: 500;
    color: #6c757d;
}

.info-value {
    font-weight: 600;
    color: #2c3e50;
}

.permission-group {
    background: #f8f9fa;
    padding: 1rem;
    border-radius: 8px;
}

.permission-group .form-check {
    margin-bottom: 0.5rem;
}

.permission-group .form-check:last-child {
    margin-bottom: 0;
}

.template-item {
    padding: 1rem;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    background: #f8f9fa;
}

.template-name {
    font-weight: 600;
    color: #2c3e50;
}

.template-desc {
    font-size: 0.8rem;
}

.status-item {
    padding: 0.5rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.status-item:last-child {
    border-bottom: none;
}

.status-label {
    font-weight: 500;
    color: #6c757d;
}

.user-row {
    cursor: pointer;
}

.user-row:hover {
    background-color: #f8f9fa;
}

.custom-permissions-count {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

#modalUserAvatar {
    width: 50px;
    height: 50px;
    font-size: 18px;
}

.log-controls .input-group {
    width: 250px;
}

.update-status .alert {
    margin-bottom: 0;
    font-size: 0.875rem;
}
</style>

<script>
// Global variables
let currentUserId = null;
let userPermissions = [];

// Update uptime
function updateUptime() {
    const startTime = new Date("2024-01-01");
    const now = new Date();
    const diff = now - startTime;
    const days = Math.floor(diff / (1000 * 60 * 60 * 24));
    const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    
    const uptimeElement = document.getElementById("uptime");
    if (uptimeElement) {
        uptimeElement.textContent = days + " ngày " + hours + " giờ";
    }
}

// System Settings Form
document.getElementById("systemSettingsForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    // Show loading
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Đang lưu...';
    submitBtn.disabled = true;
    
    // Simulate API call
    setTimeout(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
        showNotification("Cài đặt hệ thống đã được lưu thành công!", "success");
    }, 1000);
});

// KPI Settings Form
document.getElementById("kpiSettingsForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Đang lưu...';
    submitBtn.disabled = true;
    
    setTimeout(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
        showNotification("Cài đặt KPI đã được lưu thành công!", "success");
    }, 1000);
});

// Security Settings Form
document.getElementById("securitySettingsForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Đang lưu...';
    submitBtn.disabled = true;
    
    setTimeout(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
        showNotification("Cài đặt bảo mật đã được lưu thành công!", "success");
    }, 1000);
});

// Email Settings Form
document.getElementById("emailSettingsForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Đang lưu...';
    submitBtn.disabled = true;
    
    setTimeout(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
        showNotification("Cài đặt Email đã được lưu thành công!", "success");
    }, 1000);
});

// User Permissions Management
function filterUsers() {
    const filter = document.getElementById("userFilter").value;
    const rows = document.querySelectorAll(".user-row");
    
    rows.forEach(row => {
        if (filter === "all" || row.dataset.role === filter) {
            row.style.display = "";
        } else {
            row.style.display = "none";
        }
    });
}

function editUserPermissions(userId, userName) {
    currentUserId = userId;
    
    // Update modal info
    document.getElementById("modalUserName").textContent = userName;
    document.getElementById("modalUserAvatar").textContent = userName.charAt(0).toUpperCase();
    
    // Load user permissions (simulate API call)
    loadUserPermissions(userId);
    
    // Show modal
    const modal = new bootstrap.Modal(document.getElementById("userPermissionsModal"));
    modal.show();
}

function loadUserPermissions(userId) {
    // Simulate loading user permissions
    const mockPermissions = [
        "view_dashboard", "view_reports", "view_tasks", "create_tasks", "view_sales"
    ];
    
    // Reset all checkboxes
    document.querySelectorAll('#userPermissionsModal input[type="checkbox"]').forEach(cb => {
        cb.checked = false;
    });
    
    // Check user permissions
    mockPermissions.forEach(permission => {
        const checkbox = document.getElementById("perm_" + permission);
        if (checkbox) {
            checkbox.checked = true;
        }
    });
    
    userPermissions = mockPermissions;
    updateCustomPermissionCount(userId, mockPermissions.length);
}

function saveUserPermissions() {
    const checkedPermissions = [];
    document.querySelectorAll('#userPermissionsModal input[type="checkbox"]:checked').forEach(cb => {
        checkedPermissions.push(cb.value);
    });
    
    // Simulate API call
    setTimeout(() => {
        updateCustomPermissionCount(currentUserId, checkedPermissions.length);
        showNotification("Quyền người dùng đã được cập nhật thành công!", "success");
        
        // Close modal
        const modal = bootstrap.Modal.getInstance(document.getElementById("userPermissionsModal"));
        modal.hide();
    }, 500);
}

function updateCustomPermissionCount(userId, count) {
    const badge = document.querySelector(`.custom-permissions-count[data-user-id="${userId}"]`);
    if (badge) {
        badge.textContent = count;
    }
    
    // Update total count
    const totalCustom = document.querySelectorAll('.custom-permissions-count').length;
    const customCountElement = document.getElementById("customPermissionCount");
    if (customCountElement) {
        customCountElement.textContent = totalCustom;
    }
}

// KPI Templates
function applyTemplate(templateId) {
    const templates = {
        1: { service: 40000000, product: 15000000 },
        2: { service: 35000000, product: 20000000 },
        3: { service: 25000000, product: 30000000 }
    };
    
    const template = templates[templateId];
    if (template) {
        document.getElementById("defaultServiceTarget").value = template.service;
        document.getElementById("defaultProductTarget").value = template.product;
        showNotification("Template KPI đã được áp dụng!", "info");
    }
}

function createKpiTemplate() {
    const servicTarget = document.getElementById("defaultServiceTarget").value;
    const productTarget = document.getElementById("defaultProductTarget").value;
    
    if (servicTarget && productTarget) {
        showNotification("Template KPI mới đã được tạo!", "success");
    } else {
        showNotification("Vui lòng nhập đầy đủ thông tin mục tiêu!", "warning");
    }
}

// System Actions
function clearCache() {
    if (confirm("Bạn có chắc chắn muốn xóa cache hệ thống?")) {
        showLoadingToast("Đang xóa cache...");
        setTimeout(() => {
            showNotification("Cache hệ thống đã được xóa thành công!", "success");
        }, 2000);
    }
}

function createBackup() {
    if (confirm("Bạn có muốn tạo bản sao lưu cơ sở dữ liệu?")) {
        showLoadingToast("Đang tạo bản sao lưu...");
        setTimeout(() => {
            showNotification("Sao lưu cơ sở dữ liệu đã hoàn thành!", "success");
        }, 3000);
    }
}

function exportSystemData() {
    showLoadingToast("Đang xuất dữ liệu...");
    setTimeout(() => {
        showNotification("Dữ liệu hệ thống đã được xuất thành công!", "success");
    }, 2000);
}

function viewSystemLogs() {
    // Switch to audit logs tab
    const auditTab = document.querySelector('a[href="#audit-logs"]');
    if (auditTab) {
        auditTab.click();
        loadAuditLogs();
    }
}

function checkSystemHealth() {
    showLoadingToast("Đang kiểm tra sức khỏe hệ thống...");
    setTimeout(() => {
        showNotification("Hệ thống hoạt động bình thường!", "success");
    }, 2000);
}

// Security Actions
function resetFailedLogins() {
    if (confirm("Bạn có muốn reset tất cả failed login attempts?")) {
        showLoadingToast("Đang reset failed logins...");
        setTimeout(() => {
            showNotification("Failed login attempts đã được reset!", "success");
        }, 1000);
    }
}

function viewSecurityLogs() {
    showNotification("Chức năng xem security logs sẽ được phát triển!", "info");
}

// Audit Logs
function loadAuditLogs() {
    const tbody = document.getElementById("auditLogsTableBody");
    if (!tbody) return;
    
    // Show loading
    tbody.innerHTML = `
        <tr>
            <td colspan="6" class="text-center py-4">
                <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                Đang tải nhật ký...
            </td>
        </tr>
    `;
    
    // Simulate API call
    setTimeout(() => {
        const mockLogs = [
            {
                time: "2024-11-02 14:30:25",
                user: "Admin User",
                action: "Đăng nhập",
                object: "Hệ thống",
                ip: "192.168.1.100",
                details: "Đăng nhập thành công"
            },
            {
                time: "2024-11-02 14:25:10",
                user: "Manager User",
                action: "Cập nhật",
                object: "KPI Settings",
                ip: "192.168.1.101",
                details: "Thay đổi mục tiêu doanh số"
            },
            {
                time: "2024-11-02 14:20:05",
                user: "Employee User",
                action: "Tạo mới",
                object: "Task",
                ip: "192.168.1.102",
                details: "Tạo nhiệm vụ mới: Chăm sóc khách hàng VIP"
            }
        ];
        
        tbody.innerHTML = mockLogs.map(log => `
            <tr>
                <td>${log.time}</td>
                <td>${log.user}</td>
                <td>
                    <span class="badge bg-${getActionBadgeColor(log.action)}">${log.action}</span>
                </td>
                <td>${log.object}</td>
                <td><code>${log.ip}</code></td>
                <td>${log.details}</td>
            </tr>
        `).join('');
    }, 1000);
}

function refreshLogs() {
    loadAuditLogs();
}

function getActionBadgeColor(action) {
    switch(action) {
        case "Đăng nhập": return "success";
        case "Tạo mới": return "primary";
        case "Cập nhật": return "warning";
        case "Xóa": return "danger";
        default: return "secondary";
    }
}

// Utility Functions
function showNotification(message, type = "info") {
    // Create toast element
    const toast = document.createElement("div");
    toast.className = `toast align-items-center text-white bg-${type} border-0`;
    toast.setAttribute("role", "alert");
    toast.innerHTML = `
        <div class="d-flex">
            <div class="toast-body">${message}</div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
        </div>
    `;
    
    // Add to toast container
    let container = document.getElementById("toast-container");
    if (!container) {
        container = document.createElement("div");
        container.id = "toast-container";
        container.className = "toast-container position-fixed top-0 end-0 p-3";
        container.style.zIndex = "9999";
        document.body.appendChild(container);
    }
    
    container.appendChild(toast);
    
    // Show toast
    const bsToast = new bootstrap.Toast(toast);
    bsToast.show();
    
    // Remove after hide
    toast.addEventListener("hidden.bs.toast", () => {
        toast.remove();
    });
}

function showLoadingToast(message) {
    const toast = document.createElement("div");
    toast.className = "toast align-items-center text-white bg-info border-0";
    toast.setAttribute("role", "alert");
    toast.innerHTML = `
        <div class="d-flex">
            <div class="toast-body">
                <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                ${message}
            </div>
        </div>
    `;
    
    let container = document.getElementById("toast-container");
    if (!container) {
        container = document.createElement("div");
        container.id = "toast-container";
        container.className = "toast-container position-fixed top-0 end-0 p-3";
        container.style.zIndex = "9999";
        document.body.appendChild(container);
    }
    
    container.appendChild(toast);
    
    const bsToast = new bootstrap.Toast(toast, { autohide: false });
    bsToast.show();
    
    return {
        hide: () => {
            bsToast.hide();
            setTimeout(() => toast.remove(), 300);
        }
    };
}

// Initialize when DOM is loaded
document.addEventListener("DOMContentLoaded", function() {
    updateUptime();
    setInterval(updateUptime, 60000);
    
    // Load audit logs if tab is active
    const auditTab = document.querySelector('a[href="#audit-logs"]');
    if (auditTab) {
        auditTab.addEventListener("shown.bs.tab", loadAuditLogs);
    }
    
    // Initialize custom permission counts
    document.querySelectorAll('.custom-permissions-count').forEach((badge, index) => {
        badge.textContent = Math.floor(Math.random() * 5);
    });
});
</script>';

include 'layout.php';
?>