<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Doanh số dịch vụ</h1>
            <p class="page-subtitle text-muted">Theo dõi và quản lý doanh thu từ các dịch vụ spa</p>
        </div>
        <div class="col-auto">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addServiceSaleModal">
                <i class="fas fa-plus me-2"></i>Thêm doanh số dịch vụ
            </button>
        </div>
    </div>
</div>

<!-- Service Sales Overview -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số hôm nay</div>
                        <div class="value text-primary" id="todayServiceSales">' . number_format(8300000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+18% so với hôm qua</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-concierge-bell"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số tháng</div>
                        <div class="value text-success" id="monthServiceSales">' . number_format(28500000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+15% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Số lượt dịch vụ</div>
                        <div class="value text-warning" id="serviceCount">85</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+12 lượt</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-hand-sparkles"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Giá trị trung bình</div>
                        <div class="value text-info" id="avgServiceValue">' . number_format(335294, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+3% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Service Sales Chart -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Biểu đồ doanh số dịch vụ 30 ngày</h5>
                <div class="chart-controls">
                    <div class="btn-group btn-group-sm" role="group">
                        <input type="radio" class="btn-check" name="serviceChartType" id="serviceLineChart" autocomplete="off" checked>
                        <label class="btn btn-outline-secondary" for="serviceLineChart">Đường</label>
                        
                        <input type="radio" class="btn-check" name="serviceChartType" id="serviceBarChart" autocomplete="off">
                        <label class="btn btn-outline-secondary" for="serviceBarChart">Cột</label>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="serviceSalesChart"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Top Services -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Top dịch vụ được yêu thích</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Dịch vụ</th>
                                <th>Danh mục</th>
                                <th>Số lượt</th>
                                <th>Doanh thu</th>
                                <th>Thời gian TB</th>
                                <th>Tăng trưởng</th>
                                <th>Thao tác</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="service-icon me-3">
                                            <i class="fas fa-spa text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="service-name">Massage thư giãn toàn thân</div>
                                            <div class="service-code text-muted small">DV001</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Massage</td>
                                <td><span class="fw-bold">28</span> lượt</td>
                                <td class="fw-bold text-success">' . number_format(11200000, 0, ',', '.') . 'đ</td>
                                <td>90 phút</td>
                                <td><span class="badge bg-success">+22%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewServiceDetail(1)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="service-icon me-3">
                                            <i class="fas fa-leaf text-success"></i>
                                        </div>
                                        <div>
                                            <div class="service-name">Chăm sóc da mặt chuyên sâu</div>
                                            <div class="service-code text-muted small">DV002</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Chăm sóc da</td>
                                <td><span class="fw-bold">22</span> lượt</td>
                                <td class="fw-bold text-success">' . number_format(8800000, 0, ',', '.') . 'đ</td>
                                <td>75 phút</td>
                                <td><span class="badge bg-success">+18%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewServiceDetail(2)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="service-icon me-3">
                                            <i class="fas fa-tint text-info"></i>
                                        </div>
                                        <div>
                                            <div class="service-name">Tắm trắng toàn thân</div>
                                            <div class="service-code text-muted small">DV003</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Làm đẹp</td>
                                <td><span class="fw-bold">18</span> lượt</td>
                                <td class="fw-bold text-success">' . number_format(5400000, 0, ',', '.') . 'đ</td>
                                <td>60 phút</td>
                                <td><span class="badge bg-warning">+8%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewServiceDetail(3)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="service-icon me-3">
                                            <i class="fas fa-fire text-warning"></i>
                                        </div>
                                        <div>
                                            <div class="service-name">Massage đá nóng</div>
                                            <div class="service-code text-muted small">DV004</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Massage</td>
                                <td><span class="fw-bold">12</span> lượt</td>
                                <td class="fw-bold text-success">' . number_format(4800000, 0, ',', '.') . 'đ</td>
                                <td>120 phút</td>
                                <td><span class="badge bg-success">+15%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewServiceDetail(4)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="service-icon me-3">
                                            <i class="fas fa-cut text-danger"></i>
                                        </div>
                                        <div>
                                            <div class="service-name">Triệt lông vĩnh viễn</div>
                                            <div class="service-code text-muted small">DV005</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Làm đẹp</td>
                                <td><span class="fw-bold">8</span> lượt</td>
                                <td class="fw-bold text-success">' . number_format(3200000, 0, ',', '.') . 'đ</td>
                                <td>45 phút</td>
                                <td><span class="badge bg-danger">-5%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewServiceDetail(5)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Service Categories & Analytics -->
    <div class="col-xl-4 mb-4">
        <!-- Service Categories -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Doanh số theo danh mục dịch vụ</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="serviceCategoryChart"></canvas>
                </div>
                <div class="category-stats mt-3">
                    <div class="category-item mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="category-name">Massage</span>
                            <span class="category-amount fw-bold">16.0M</span>
                        </div>
                        <div class="progress thin-progress">
                            <div class="progress-bar bg-primary" style="width: 56%"></div>
                        </div>
                    </div>
                    
                    <div class="category-item mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="category-name">Chăm sóc da</span>
                            <span class="category-amount fw-bold">8.8M</span>
                        </div>
                        <div class="progress thin-progress">
                            <div class="progress-bar bg-success" style="width: 31%"></div>
                        </div>
                    </div>
                    
                    <div class="category-item mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="category-name">Làm đẹp</span>
                            <span class="category-amount fw-bold">3.7M</span>
                        </div>
                        <div class="progress thin-progress">
                            <div class="progress-bar bg-warning" style="width: 13%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Service Performance -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Hiệu suất dịch vụ</h5>
            </div>
            <div class="card-body">
                <div class="performance-metrics">
                    <div class="metric-item mb-3">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="metric-label">Tỷ lệ hài lòng khách hàng</span>
                            <span class="metric-value fw-bold text-success">94%</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-success" style="width: 94%"></div>
                        </div>
                    </div>
                    
                    <div class="metric-item mb-3">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="metric-label">Tỷ lệ khách hàng quay lại</span>
                            <span class="metric-value fw-bold text-info">78%</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-info" style="width: 78%"></div>
                        </div>
                    </div>
                    
                    <div class="metric-item mb-3">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="metric-label">Thời gian chờ trung bình</span>
                            <span class="metric-value fw-bold text-warning">12 phút</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-warning" style="width: 60%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Recent Service Sales -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Giao dịch dịch vụ gần đây</h5>
                <button class="btn btn-sm btn-outline-primary" onclick="refreshServiceSales()">
                    <i class="fas fa-sync-alt"></i>
                </button>
            </div>
            <div class="card-body p-0">
                <div class="sales-list">
                    <div class="sale-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="sale-icon me-3">
                                <i class="fas fa-spa text-primary"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="sale-description">Massage thư giãn 90 phút</div>
                                <div class="sale-meta text-muted small">
                                    ' . date('H:i') . ' • Nguyễn Thị A
                                </div>
                            </div>
                            <div class="sale-amount text-end">
                                <div class="fw-bold text-primary">' . number_format(650000, 0, ',', '.') . 'đ</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="sale-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="sale-icon me-3">
                                <i class="fas fa-leaf text-success"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="sale-description">Chăm sóc da mặt chuyên sâu</div>
                                <div class="sale-meta text-muted small">
                                    ' . date('H:i', strtotime('-1 hour')) . ' • Trần Văn B
                                </div>
                            </div>
                            <div class="sale-amount text-end">
                                <div class="fw-bold text-primary">' . number_format(450000, 0, ',', '.') . 'đ</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="sale-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="sale-icon me-3">
                                <i class="fas fa-tint text-info"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="sale-description">Tắm trắng toàn thân</div>
                                <div class="sale-meta text-muted small">
                                    ' . date('H:i', strtotime('-2 hours')) . ' • Lê Thị C
                                </div>
                            </div>
                            <div class="sale-amount text-end">
                                <div class="fw-bold text-primary">' . number_format(350000, 0, ',', '.') . 'đ</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Service Sale Modal -->
<div class="modal fade" id="addServiceSaleModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Thêm doanh số dịch vụ</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addServiceSaleForm" method="POST" action="/api/sales/create">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="serviceName" class="form-label">Tên dịch vụ</label>
                        <select class="form-select" id="serviceName" name="description" required>
                            <option value="">Chọn dịch vụ</option>
                            <option value="Massage thư giãn toàn thân">Massage thư giãn toàn thân</option>
                            <option value="Chăm sóc da mặt chuyên sâu">Chăm sóc da mặt chuyên sâu</option>
                            <option value="Tắm trắng toàn thân">Tắm trắng toàn thân</option>
                            <option value="Massage đá nóng">Massage đá nóng</option>
                            <option value="Triệt lông vĩnh viễn">Triệt lông vĩnh viễn</option>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="serviceDuration" class="form-label">Thời gian (phút)</label>
                                <select class="form-select" id="serviceDuration" name="duration">
                                    <option value="30">30 phút</option>
                                    <option value="45">45 phút</option>
                                    <option value="60" selected>60 phút</option>
                                    <option value="75">75 phút</option>
                                    <option value="90">90 phút</option>
                                    <option value="120">120 phút</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="servicePrice" class="form-label">Giá dịch vụ</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="servicePrice" name="amount" required min="0">
                                    <span class="input-group-text">đ</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="customerName" class="form-label">Tên khách hàng</label>
                        <input type="text" class="form-control" id="customerName" name="customer_name">
                    </div>
                    <div class="mb-3">
                        <label for="serviceSaleDate" class="form-label">Thời gian thực hiện</label>
                        <input type="datetime-local" class="form-control" id="serviceSaleDate" name="sale_date" required>
                    </div>
                    <input type="hidden" name="type" value="service">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">Thêm doanh số</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.service-icon {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1rem;
}
.service-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.service-code {
    font-size: 0.8rem;
}
.category-item {
    margin-bottom: 0.75rem;
}
.category-name {
    font-size: 0.9rem;
    color: #6c757d;
}
.category-amount {
    font-size: 0.9rem;
    color: #2c3e50;
}
.thin-progress {
    height: 4px;
    margin-top: 0.25rem;
}
.metric-item {
    padding: 0.5rem 0;
}
.metric-label {
    font-size: 0.9rem;
    color: #6c757d;
}
.metric-value {
    font-size: 0.9rem;
}
</style>

<script>
// Service Sales Chart
const serviceSalesCtx = document.getElementById("serviceSalesChart").getContext("2d");
let serviceSalesChart = new Chart(serviceSalesCtx, {
    type: "line",
    data: {
        labels: Array.from({length: 30}, (_, i) => {
            const date = new Date();
            date.setDate(date.getDate() - (29 - i));
            return date.getDate() + "/" + (date.getMonth() + 1);
        }),
        datasets: [{
            label: "Doanh số dịch vụ",
            data: Array.from({length: 30}, () => Math.floor(Math.random() * 1500000) + 500000),
            borderColor: "#4a90e2",
            backgroundColor: "rgba(74, 144, 226, 0.1)",
            borderWidth: 2,
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return "Doanh số: " + 
                               new Intl.NumberFormat("vi-VN", { 
                                   style: "currency", 
                                   currency: "VND",
                                   minimumFractionDigits: 0 
                               }).format(context.raw);
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        if (value >= 1000000) {
                            return (value / 1000000) + " tr";
                        }
                        return new Intl.NumberFormat("vi-VN", { 
                            style: "currency", 
                            currency: "VND", 
                            minimumFractionDigits: 0 
                        }).format(value);
                    }
                }
            }
        }
    }
});

// Service Category Chart
const serviceCategoryCtx = document.getElementById("serviceCategoryChart").getContext("2d");
const serviceCategoryChart = new Chart(serviceCategoryCtx, {
    type: "doughnut",
    data: {
        labels: ["Massage", "Chăm sóc da", "Làm đẹp"],
        datasets: [{
            data: [16000000, 8800000, 3700000],
            backgroundColor: [
                "#4a90e2",
                "#55efc4", 
                "#fdcb6e"
            ],
            borderWidth: 0
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: "bottom",
                labels: {
                    usePointStyle: true,
                    padding: 15
                }
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const total = context.dataset.data.reduce((a, b) => a + b, 0);
                        const percentage = ((context.raw / total) * 100).toFixed(1);
                        return context.label + ": " + 
                               new Intl.NumberFormat("vi-VN", { 
                                   style: "currency", 
                                   currency: "VND",
                                   minimumFractionDigits: 0 
                               }).format(context.raw) + 
                               " (" + percentage + "%)";
                    }
                }
            }
        }
    }
});

// Chart type toggle
document.querySelectorAll("input[name=\"serviceChartType\"]").forEach(radio => {
    radio.addEventListener("change", function() {
        serviceSalesChart.destroy();
        serviceSalesChart = new Chart(serviceSalesCtx, {
            type: this.id === "serviceLineChart" ? "line" : "bar",
            data: serviceSalesChart.data,
            options: serviceSalesChart.options
        });
    });
});

// Service actions
function viewServiceDetail(id) {
    alert("Xem chi tiết dịch vụ ID: " + id);
}

function refreshServiceSales() {
    location.reload();
}

// Add service sale form
document.getElementById("addServiceSaleForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    fetch("/api/sales/create", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById("addServiceSaleModal")).hide();
            location.reload();
        } else {
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        }
    })
    .catch(error => {
        console.error("Error:", error);
        alert("Có lỗi xảy ra. Vui lòng thử lại.");
    });
});

// Set default datetime
document.getElementById("serviceSaleDate").value = new Date().toISOString().slice(0, 16);

// Auto-refresh mỗi 30 giây
setInterval(() => {
    if (!document.querySelector(".modal.show")) {
        location.reload();
    }
}, 30000);
</script>';

include 'layout.php';
?>