<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">KPI Cá nhân</h1>
            <p class="page-subtitle text-muted">Theo dõi và đánh giá hiệu suất làm việc tháng ' . date('m/Y') . '</p>
        </div>
        <div class="col-auto">
            <div class="btn-group" role="group">
                <input type="radio" class="btn-check" name="kpiPeriod" id="thisMonth" autocomplete="off" checked>
                <label class="btn btn-outline-primary" for="thisMonth">Tháng này</label>
                
                <input type="radio" class="btn-check" name="kpiPeriod" id="lastMonth" autocomplete="off">
                <label class="btn btn-outline-primary" for="lastMonth">Tháng trước</label>
                
                <input type="radio" class="btn-check" name="kpiPeriod" id="quarter" autocomplete="off">
                <label class="btn btn-outline-primary" for="quarter">Quý này</label>
            </div>
        </div>
    </div>
</div>

<!-- KPI Overview -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tổng tiến độ KPI</div>
                        <div class="value text-primary" id="overallKpi">' . (isset($kpiProgress) && !empty($kpiProgress) ? round(array_sum(array_column($kpiProgress, 'percentage')) / count($kpiProgress)) : 0) . '%</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+5% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Mục tiêu đạt được</div>
                        <div class="value text-success" id="achievedTargets">' . (isset($kpiProgress) ? count(array_filter($kpiProgress, function($kpi) { return $kpi['percentage'] >= 100; })) : 0) . '/' . (isset($kpiProgress) ? count($kpiProgress) : 0) . '</div>
                        <div class="progress thin-progress mt-2">
                            <div class="progress-bar bg-success" style="width: ' . (isset($kpiProgress) && count($kpiProgress) > 0 ? (count(array_filter($kpiProgress, function($kpi) { return $kpi['percentage'] >= 100; })) / count($kpiProgress)) * 100 : 0) . '%"></div>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-bullseye"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số tháng</div>
                        <div class="value text-warning" id="monthlySales">' . number_format(45200000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+12% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Xếp hạng</div>
                        <div class="value text-info" id="ranking">#3</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>Tăng 2 bậc</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-trophy"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- KPI Progress Details -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Chi tiết tiến độ KPI</h5>
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-download me-2"></i>Xuất báo cáo</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-chart-bar me-2"></i>Xem biểu đồ</a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="kpi-progress-list">
                    ' . (function() use ($kpiProgress) {
                        $html = '';
                        if (empty($kpiProgress)) {
                            // Dữ liệu mẫu nếu chưa có KPI
                            $sampleKpis = [
                                ['name' => 'Doanh số dịch vụ', 'target' => 50000000, 'achieved' => 38500000, 'percentage' => 77],
                                ['name' => 'Doanh số sản phẩm', 'target' => 20000000, 'achieved' => 15200000, 'percentage' => 76],
                                ['name' => 'Khách hàng mới', 'target' => 30, 'achieved' => 22, 'percentage' => 73],
                                ['name' => 'Tỷ lệ hài lòng khách hàng', 'target' => 95, 'achieved' => 92, 'percentage' => 97],
                                ['name' => 'Số giờ làm việc', 'target' => 160, 'achieved' => 145, 'percentage' => 91]
                            ];
                            $kpiProgress = $sampleKpis;
                        }
                        
                        foreach($kpiProgress as $kpi) {
                            $percentage = (int)$kpi['percentage'];
                            $progressClass = $percentage >= 100 ? 'bg-success' : 
                                           ($percentage >= 80 ? 'bg-info' : 
                                           ($percentage >= 60 ? 'bg-warning' : 'bg-danger'));
                            
                            $statusIcon = $percentage >= 100 ? 'fa-check-circle text-success' : 
                                        ($percentage >= 80 ? 'fa-arrow-up text-info' : 
                                        ($percentage >= 60 ? 'fa-minus text-warning' : 'fa-arrow-down text-danger'));
                            
                            $html .= '
                            <div class="kpi-progress-item mb-4">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div class="kpi-info">
                                        <h6 class="kpi-name mb-1">' . htmlspecialchars($kpi['name']) . '</h6>
                                        <div class="kpi-details">
                                            <span class="achieved">' . (is_numeric($kpi['achieved']) ? number_format($kpi['achieved'], 0, ',', '.') : $kpi['achieved']) . '</span>
                                            <span class="text-muted"> / </span>
                                            <span class="target">' . (is_numeric($kpi['target']) ? number_format($kpi['target'], 0, ',', '.') : $kpi['target']) . '</span>
                                            ' . (strpos($kpi['name'], 'Doanh số') !== false ? '<span class="text-muted">đ</span>' : '') . '
                                        </div>
                                    </div>
                                    <div class="kpi-status text-end">
                                        <div class="kpi-percentage">' . $percentage . '%</div>
                                        <i class="fas ' . $statusIcon . '"></i>
                                    </div>
                                </div>
                                <div class="progress kpi-progress-bar">
                                    <div class="progress-bar ' . $progressClass . '" role="progressbar" 
                                         style="width: ' . min(100, $percentage) . '%" 
                                         data-percentage="' . $percentage . '"></div>
                                </div>
                                <div class="kpi-actions mt-2">
                                    <small class="text-muted">
                                        Còn lại: ' . max(0, $kpi['target'] - $kpi['achieved']) . ' 
                                        ' . (strpos($kpi['name'], 'Doanh số') !== false ? 'đ' : '') . '
                                        • Cần đạt: ' . round(max(0, $kpi['target'] - $kpi['achieved']) / (date('t') - date('j') + 1), 0) . '/ngày
                                    </small>
                                </div>
                            </div>';
                        }
                        return $html;
                    })() . '
                </div>
            </div>
        </div>
        
        <!-- KPI Chart -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Biểu đồ tiến độ KPI theo tuần</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="kpiChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    
    <!-- KPI Insights & Actions -->
    <div class="col-xl-4 mb-4">
        <!-- Performance Insights -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Phân tích hiệu suất</h5>
            </div>
            <div class="card-body">
                <div class="insight-list">
                    <div class="insight-item mb-3">
                        <div class="insight-icon text-success">
                            <i class="fas fa-thumbs-up"></i>
                        </div>
                        <div class="insight-content">
                            <div class="insight-title">Điểm mạnh</div>
                            <div class="insight-text">Doanh số dịch vụ tăng trưởng ổn định, vượt kế hoạch 7%</div>
                        </div>
                    </div>
                    
                    <div class="insight-item mb-3">
                        <div class="insight-icon text-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                        <div class="insight-content">
                            <div class="insight-title">Cần cải thiện</div>
                            <div class="insight-text">Doanh số sản phẩm chưa đạt mục tiêu, cần tăng cường bán hàng</div>
                        </div>
                    </div>
                    
                    <div class="insight-item mb-3">
                        <div class="insight-icon text-info">
                            <i class="fas fa-lightbulb"></i>
                        </div>
                        <div class="insight-content">
                            <div class="insight-title">Gợi ý</div>
                            <div class="insight-text">Tập trung chăm sóc khách hàng cũ để tăng tỷ lệ quay lại</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Hành động nhanh</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-primary btn-sm" onclick="updateSales()">
                        <i class="fas fa-plus me-2"></i>Cập nhật doanh số
                    </button>
                    <button class="btn btn-success btn-sm" onclick="addCustomer()">
                        <i class="fas fa-user-plus me-2"></i>Thêm khách hàng mới
                    </button>
                    <button class="btn btn-info btn-sm" onclick="viewReport()">
                        <i class="fas fa-chart-bar me-2"></i>Xem báo cáo chi tiết
                    </button>
                    <button class="btn btn-warning btn-sm" onclick="setReminder()">
                        <i class="fas fa-bell me-2"></i>Đặt nhắc nhở
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Team Ranking -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Bảng xếp hạng team</h5>
            </div>
            <div class="card-body p-0">
                <div class="ranking-list">
                    <div class="ranking-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="ranking-position me-3">
                                <span class="badge bg-warning">1</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="ranking-name">Nguyễn Thị A</div>
                                <div class="ranking-score text-muted small">95% KPI</div>
                            </div>
                            <div class="ranking-badge">
                                <i class="fas fa-crown text-warning"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="ranking-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="ranking-position me-3">
                                <span class="badge bg-secondary">2</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="ranking-name">Trần Văn B</div>
                                <div class="ranking-score text-muted small">88% KPI</div>
                            </div>
                            <div class="ranking-badge">
                                <i class="fas fa-medal text-secondary"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="ranking-item p-3 border-bottom bg-light">
                        <div class="d-flex align-items-center">
                            <div class="ranking-position me-3">
                                <span class="badge bg-info">3</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="ranking-name fw-bold">Bạn</div>
                                <div class="ranking-score text-muted small">82% KPI</div>
                            </div>
                            <div class="ranking-badge">
                                <i class="fas fa-user text-info"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="ranking-item p-3">
                        <div class="d-flex align-items-center">
                            <div class="ranking-position me-3">
                                <span class="badge bg-light text-dark">4</span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="ranking-name">Lê Thị C</div>
                                <div class="ranking-score text-muted small">75% KPI</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.kpi-progress-item {
    padding: 1rem;
    border: 1px solid #f0f0f0;
    border-radius: 8px;
    background: #fafafa;
    transition: all 0.3s ease;
}
.kpi-progress-item:hover {
    background: #f5f5f5;
    border-color: #e0e0e0;
}
.kpi-name {
    font-weight: 600;
    color: #2c3e50;
}
.kpi-details {
    font-size: 0.9rem;
}
.achieved {
    font-weight: 600;
    color: #27ae60;
}
.target {
    font-weight: 500;
    color: #7f8c8d;
}
.kpi-percentage {
    font-size: 1.25rem;
    font-weight: 700;
    color: #2c3e50;
}
.kpi-progress-bar {
    height: 10px;
    border-radius: 5px;
    background-color: #ecf0f1;
}
.insight-item {
    display: flex;
    align-items-flex-start;
}
.insight-icon {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 0.75rem;
    font-size: 0.9rem;
}
.insight-icon.text-success { background: rgba(39, 174, 96, 0.1); }
.insight-icon.text-warning { background: rgba(243, 156, 18, 0.1); }
.insight-icon.text-info { background: rgba(52, 152, 219, 0.1); }
.insight-title {
    font-weight: 600;
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}
.insight-text {
    font-size: 0.85rem;
    color: #6c757d;
    line-height: 1.4;
}
.ranking-item:last-child {
    border-bottom: none !important;
}
.ranking-position .badge {
    width: 24px;
    height: 24px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
}
.ranking-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.ranking-score {
    font-size: 0.8rem;
}
</style>

<script>
// Biểu đồ KPI theo tuần
const kpiCtx = document.getElementById("kpiChart").getContext("2d");
const kpiChart = new Chart(kpiCtx, {
    type: "line",
    data: {
        labels: ["Tuần 1", "Tuần 2", "Tuần 3", "Tuần 4"],
        datasets: [{
            label: "Doanh số dịch vụ",
            data: [65, 70, 75, 77],
            borderColor: "#4a90e2",
            backgroundColor: "rgba(74, 144, 226, 0.1)",
            borderWidth: 3,
            tension: 0.4,
            fill: true
        }, {
            label: "Doanh số sản phẩm", 
            data: [60, 65, 72, 76],
            borderColor: "#55efc4",
            backgroundColor: "rgba(85, 239, 196, 0.1)",
            borderWidth: 3,
            tension: 0.4,
            fill: true
        }, {
            label: "Khách hàng mới",
            data: [50, 60, 68, 73],
            borderColor: "#fdcb6e",
            backgroundColor: "rgba(253, 203, 110, 0.1)",
            borderWidth: 3,
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: "bottom",
                labels: {
                    usePointStyle: true,
                    padding: 20
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                max: 100,
                grid: {
                    color: "rgba(0, 0, 0, 0.05)"
                },
                ticks: {
                    callback: function(value) {
                        return value + "%";
                    }
                }
            },
            x: {
                grid: {
                    display: false
                }
            }
        }
    }
});

// Animate progress bars
document.querySelectorAll(".progress-bar").forEach(bar => {
    const percentage = bar.dataset.percentage;
    bar.style.width = "0%";
    setTimeout(() => {
        bar.style.transition = "width 1.5s ease-in-out";
        bar.style.width = Math.min(100, percentage) + "%";
    }, 500);
});

// Quick action functions
function updateSales() {
    // Redirect to sales page or open modal
    window.location.href = "/sales";
}

function addCustomer() {
    alert("Tính năng thêm khách hàng sẽ được phát triển trong phiên bản tiếp theo");
}

function viewReport() {
    alert("Tính năng báo cáo chi tiết sẽ được phát triển trong phiên bản tiếp theo");
}

function setReminder() {
    alert("Tính năng nhắc nhở sẽ được phát triển trong phiên bản tiếp theo");
}

// Handle period change
document.querySelectorAll("input[name=\"kpiPeriod\"]").forEach(radio => {
    radio.addEventListener("change", function() {
        console.log("Period changed to:", this.id);
        // Có thể thêm logic để tải lại dữ liệu theo period
    });
});

// Auto-refresh mỗi 60 giây
setInterval(() => {
    // Chỉ refresh nếu không có modal nào đang mở
    if (!document.querySelector(".modal.show")) {
        location.reload();
    }
}, 60000);
</script>';

include 'layout.php';
?>