<?php
class User {
    private $conn;
    private $table_name = "users";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function getUserByEmail($email) {
        $query = "SELECT * FROM users WHERE email = :email AND is_active = 1";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getUserById($id) {
        $query = "SELECT u.*, b.name as branch_name, d.name as department_name
                  FROM users u
                  LEFT JOIN branches b ON u.branch_id = b.id
                  LEFT JOIN departments d ON u.department_id = d.id
                  WHERE u.id = :id AND u.is_active = 1";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function createUser($data) {
        $query = "INSERT INTO users (name, email, password, role, branch_id, department_id, phone, created_at) 
                  VALUES (:name, :email, :password, :role, :branch_id, :department_id, :phone, NOW())";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':name', $data['name']);
        $stmt->bindParam(':email', $data['email']);
        $stmt->bindParam(':password', password_hash($data['password'], PASSWORD_DEFAULT));
        $stmt->bindParam(':role', $data['role']);
        $stmt->bindParam(':branch_id', $data['branch_id']);
        $stmt->bindParam(':department_id', $data['department_id']);
        $stmt->bindParam(':phone', $data['phone']);
        
        return $stmt->execute();
    }

    public function updateUser($id, $data) {
        $query = "UPDATE users 
                  SET name = :name, email = :email, role = :role, 
                      branch_id = :branch_id, department_id = :department_id, 
                      phone = :phone, updated_at = NOW()
                  WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':name', $data['name']);
        $stmt->bindParam(':email', $data['email']);
        $stmt->bindParam(':role', $data['role']);
        $stmt->bindParam(':branch_id', $data['branch_id']);
        $stmt->bindParam(':department_id', $data['department_id']);
        $stmt->bindParam(':phone', $data['phone']);
        
        return $stmt->execute();
    }

    public function updatePassword($id, $newPassword) {
        $query = "UPDATE users SET password = :password, updated_at = NOW() WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':password', password_hash($newPassword, PASSWORD_DEFAULT));
        
        return $stmt->execute();
    }

    public function deactivateUser($id) {
        $query = "UPDATE users SET is_active = 0, updated_at = NOW() WHERE id = :id AND role != 'owner'";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        
        return $stmt->execute();
    }
}
?>