<?php
class SaleController extends Controller {
    public function index() {
        if(!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }
        
        $saleModel = $this->model('Sale');
        $salesData = $saleModel->getSalesData(
            $_SESSION['user_id'], 
            $_SESSION['user_role'], 
            $_SESSION['branch_id']
        );
        
        $this->view('sales', $salesData);
    }
    
    public function create() {
        header('Content-Type: application/json');
        
        if(!isset($_SESSION['user_id'])) {
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $input = json_decode(file_get_contents('php://input'), true);
            
            $type = $input['type'] ?? '';
            $description = $input['description'] ?? '';
            $amount = $input['amount'] ?? 0;
            $saleDate = $input['sale_date'] ?? date('Y-m-d H:i:s');
            
            $saleModel = $this->model('Sale');
            $result = $saleModel->createSale(
                $_SESSION['user_id'], 
                $_SESSION['branch_id'], 
                $type, 
                $amount, 
                $description,
                $saleDate
            );
            
            echo json_encode(['success' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid method']);
        }
        exit();
    }
    
    public function recent() {
        header('Content-Type: application/json');
        
        if(!isset($_SESSION['user_id'])) {
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        $saleModel = $this->model('Sale');
        $recentSales = $saleModel->getRecentSales($_SESSION['user_role'], $_SESSION['branch_id']);
        
        echo json_encode(['success' => true, 'sales' => $recentSales]);
        exit();
    }
    
    public function products() {
        if(!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }
        
        $saleModel = $this->model('Sale');
        $productSalesData = $saleModel->getProductSalesData(
            $_SESSION['user_id'], 
            $_SESSION['user_role'], 
            $_SESSION['branch_id']
        );
        
        $this->view('sales_products', $productSalesData);
    }
    
    public function services() {
        if(!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }
        
        $saleModel = $this->model('Sale');
        $serviceSalesData = $saleModel->getServiceSalesData(
            $_SESSION['user_id'], 
            $_SESSION['user_role'], 
            $_SESSION['branch_id']
        );
        
        $this->view('sales_services', $serviceSalesData);
    }
}
?>