<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Doanh số sản phẩm</h1>
            <p class="page-subtitle text-muted">Theo dõi và quản lý doanh thu từ bán sản phẩm</p>
        </div>
        <div class="col-auto">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addProductSaleModal">
                <i class="fas fa-plus me-2"></i>Thêm doanh số sản phẩm
            </button>
        </div>
    </div>
</div>

<!-- Product Sales Overview -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số hôm nay</div>
                        <div class="value text-success" id="todayProductSales">' . number_format(4200000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+8% so với hôm qua</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-box"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số tháng</div>
                        <div class="value text-primary" id="monthProductSales">' . number_format(16700000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+12% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Số lượng bán</div>
                        <div class="value text-warning" id="productQuantity">142</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+15 sản phẩm</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Giá trị trung bình</div>
                        <div class="value text-info" id="avgProductValue">' . number_format(117606, 0, ',', '.') . 'đ</div>
                        <div class="trend text-warning">
                            <i class="fas fa-minus me-1"></i>
                            <span>-2% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Product Sales Chart -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Biểu đồ doanh số sản phẩm 30 ngày</h5>
                <div class="chart-controls">
                    <div class="btn-group btn-group-sm" role="group">
                        <input type="radio" class="btn-check" name="productChartType" id="productLineChart" autocomplete="off" checked>
                        <label class="btn btn-outline-secondary" for="productLineChart">Đường</label>
                        
                        <input type="radio" class="btn-check" name="productChartType" id="productBarChart" autocomplete="off">
                        <label class="btn btn-outline-secondary" for="productBarChart">Cột</label>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="productSalesChart"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Top Products -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Top sản phẩm bán chạy</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Sản phẩm</th>
                                <th>Danh mục</th>
                                <th>Số lượng bán</th>
                                <th>Doanh thu</th>
                                <th>Tăng trưởng</th>
                                <th>Thao tác</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="product-icon me-3">
                                            <i class="fas fa-bottle-droplet text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="product-name">Serum Vitamin C</div>
                                            <div class="product-code text-muted small">SP001</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Chăm sóc da</td>
                                <td><span class="fw-bold">45</span> chai</td>
                                <td class="fw-bold text-success">' . number_format(6750000, 0, ',', '.') . 'đ</td>
                                <td><span class="badge bg-success">+18%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewProductDetail(1)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="product-icon me-3">
                                            <i class="fas fa-pump-soap text-success"></i>
                                        </div>
                                        <div>
                                            <div class="product-name">Kem dưỡng da cao cấp</div>
                                            <div class="product-code text-muted small">SP002</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Chăm sóc da</td>
                                <td><span class="fw-bold">32</span> hộp</td>
                                <td class="fw-bold text-success">' . number_format(4800000, 0, ',', '.') . 'đ</td>
                                <td><span class="badge bg-success">+12%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewProductDetail(2)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="product-icon me-3">
                                            <i class="fas fa-spray-can text-warning"></i>
                                        </div>
                                        <div>
                                            <div class="product-name">Xịt khoáng dưỡng ẩm</div>
                                            <div class="product-code text-muted small">SP003</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Chăm sóc da</td>
                                <td><span class="fw-bold">28</span> chai</td>
                                <td class="fw-bold text-success">' . number_format(2800000, 0, ',', '.') . 'đ</td>
                                <td><span class="badge bg-warning">+5%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewProductDetail(3)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="product-icon me-3">
                                            <i class="fas fa-soap text-info"></i>
                                        </div>
                                        <div>
                                            <div class="product-name">Sữa rửa mặt làm sạch sâu</div>
                                            <div class="product-code text-muted small">SP004</div>
                                        </div>
                                    </div>
                                </td>
                                <td>Làm sạch</td>
                                <td><span class="fw-bold">22</span> tuýp</td>
                                <td class="fw-bold text-success">' . number_format(1980000, 0, ',', '.') . 'đ</td>
                                <td><span class="badge bg-danger">-3%</span></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" onclick="viewProductDetail(4)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Product Categories & Analytics -->
    <div class="col-xl-4 mb-4">
        <!-- Product Categories -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Doanh số theo danh mục</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="productCategoryChart"></canvas>
                </div>
                <div class="category-stats mt-3">
                    <div class="category-item mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="category-name">Chăm sóc da</span>
                            <span class="category-amount fw-bold">12.5M</span>
                        </div>
                        <div class="progress thin-progress">
                            <div class="progress-bar bg-primary" style="width: 75%"></div>
                        </div>
                    </div>
                    
                    <div class="category-item mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="category-name">Làm sạch</span>
                            <span class="category-amount fw-bold">2.8M</span>
                        </div>
                        <div class="progress thin-progress">
                            <div class="progress-bar bg-success" style="width: 17%"></div>
                        </div>
                    </div>
                    
                    <div class="category-item mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="category-name">Phụ kiện</span>
                            <span class="category-amount fw-bold">1.4M</span>
                        </div>
                        <div class="progress thin-progress">
                            <div class="progress-bar bg-warning" style="width: 8%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Recent Product Sales -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Giao dịch sản phẩm gần đây</h5>
                <button class="btn btn-sm btn-outline-primary" onclick="refreshProductSales()">
                    <i class="fas fa-sync-alt"></i>
                </button>
            </div>
            <div class="card-body p-0">
                <div class="sales-list">
                    <div class="sale-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="sale-icon me-3">
                                <i class="fas fa-bottle-droplet text-primary"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="sale-description">Serum Vitamin C x2</div>
                                <div class="sale-meta text-muted small">
                                    ' . date('H:i') . ' • Nguyễn Thị A
                                </div>
                            </div>
                            <div class="sale-amount text-end">
                                <div class="fw-bold text-success">' . number_format(300000, 0, ',', '.') . 'đ</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="sale-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="sale-icon me-3">
                                <i class="fas fa-pump-soap text-success"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="sale-description">Kem dưỡng da cao cấp</div>
                                <div class="sale-meta text-muted small">
                                    ' . date('H:i', strtotime('-1 hour')) . ' • Trần Văn B
                                </div>
                            </div>
                            <div class="sale-amount text-end">
                                <div class="fw-bold text-success">' . number_format(150000, 0, ',', '.') . 'đ</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="sale-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="sale-icon me-3">
                                <i class="fas fa-spray-can text-warning"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="sale-description">Xịt khoáng dưỡng ẩm x3</div>
                                <div class="sale-meta text-muted small">
                                    ' . date('H:i', strtotime('-2 hours')) . ' • Lê Thị C
                                </div>
                            </div>
                            <div class="sale-amount text-end">
                                <div class="fw-bold text-success">' . number_format(300000, 0, ',', '.') . 'đ</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Product Sale Modal -->
<div class="modal fade" id="addProductSaleModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Thêm doanh số sản phẩm</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addProductSaleForm" method="POST" action="/api/sales/create">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="productName" class="form-label">Tên sản phẩm</label>
                        <select class="form-select" id="productName" name="description" required>
                            <option value="">Chọn sản phẩm</option>
                            <option value="Serum Vitamin C">Serum Vitamin C</option>
                            <option value="Kem dưỡng da cao cấp">Kem dưỡng da cao cấp</option>
                            <option value="Xịt khoáng dưỡng ẩm">Xịt khoáng dưỡng ẩm</option>
                            <option value="Sữa rửa mặt làm sạch sâu">Sữa rửa mặt làm sạch sâu</option>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="productQuantity" class="form-label">Số lượng</label>
                                <input type="number" class="form-control" id="productQuantity" name="quantity" required min="1">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="productPrice" class="form-label">Đơn giá</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="productPrice" name="price" required min="0">
                                    <span class="input-group-text">đ</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="productTotal" class="form-label">Tổng tiền</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="productTotal" name="amount" readonly>
                            <span class="input-group-text">đ</span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="productSaleDate" class="form-label">Thời gian</label>
                        <input type="datetime-local" class="form-control" id="productSaleDate" name="sale_date" required>
                    </div>
                    <input type="hidden" name="type" value="product">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">Thêm doanh số</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.product-icon {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1rem;
}
.product-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.product-code {
    font-size: 0.8rem;
}
.category-item {
    margin-bottom: 0.75rem;
}
.category-name {
    font-size: 0.9rem;
    color: #6c757d;
}
.category-amount {
    font-size: 0.9rem;
    color: #2c3e50;
}
.thin-progress {
    height: 4px;
    margin-top: 0.25rem;
}
</style>

<script>
// Product Sales Chart
const productSalesCtx = document.getElementById("productSalesChart").getContext("2d");
let productSalesChart = new Chart(productSalesCtx, {
    type: "line",
    data: {
        labels: Array.from({length: 30}, (_, i) => {
            const date = new Date();
            date.setDate(date.getDate() - (29 - i));
            return date.getDate() + "/" + (date.getMonth() + 1);
        }),
        datasets: [{
            label: "Doanh số sản phẩm",
            data: Array.from({length: 30}, () => Math.floor(Math.random() * 800000) + 200000),
            borderColor: "#55efc4",
            backgroundColor: "rgba(85, 239, 196, 0.1)",
            borderWidth: 2,
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return "Doanh số: " + 
                               new Intl.NumberFormat("vi-VN", { 
                                   style: "currency", 
                                   currency: "VND",
                                   minimumFractionDigits: 0 
                               }).format(context.raw);
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        if (value >= 1000000) {
                            return (value / 1000000) + " tr";
                        }
                        return new Intl.NumberFormat("vi-VN", { 
                            style: "currency", 
                            currency: "VND", 
                            minimumFractionDigits: 0 
                        }).format(value);
                    }
                }
            }
        }
    }
});

// Product Category Chart
const productCategoryCtx = document.getElementById("productCategoryChart").getContext("2d");
const productCategoryChart = new Chart(productCategoryCtx, {
    type: "doughnut",
    data: {
        labels: ["Chăm sóc da", "Làm sạch", "Phụ kiện"],
        datasets: [{
            data: [12500000, 2800000, 1400000],
            backgroundColor: [
                "#4a90e2",
                "#55efc4", 
                "#fdcb6e"
            ],
            borderWidth: 0
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: "bottom",
                labels: {
                    usePointStyle: true,
                    padding: 15
                }
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const total = context.dataset.data.reduce((a, b) => a + b, 0);
                        const percentage = ((context.raw / total) * 100).toFixed(1);
                        return context.label + ": " + 
                               new Intl.NumberFormat("vi-VN", { 
                                   style: "currency", 
                                   currency: "VND",
                                   minimumFractionDigits: 0 
                               }).format(context.raw) + 
                               " (" + percentage + "%)";
                    }
                }
            }
        }
    }
});

// Chart type toggle
document.querySelectorAll("input[name=\"productChartType\"]").forEach(radio => {
    radio.addEventListener("change", function() {
        productSalesChart.destroy();
        productSalesChart = new Chart(productSalesCtx, {
            type: this.id === "productLineChart" ? "line" : "bar",
            data: productSalesChart.data,
            options: productSalesChart.options
        });
    });
});

// Calculate total amount
document.getElementById("productQuantity").addEventListener("input", calculateTotal);
document.getElementById("productPrice").addEventListener("input", calculateTotal);

function calculateTotal() {
    const quantity = parseInt(document.getElementById("productQuantity").value) || 0;
    const price = parseInt(document.getElementById("productPrice").value) || 0;
    const total = quantity * price;
    document.getElementById("productTotal").value = total;
}

// Product actions
function viewProductDetail(id) {
    alert("Xem chi tiết sản phẩm ID: " + id);
}

function refreshProductSales() {
    location.reload();
}

// Add product sale form
document.getElementById("addProductSaleForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    fetch("/api/sales/create", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById("addProductSaleModal")).hide();
            location.reload();
        } else {
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        }
    })
    .catch(error => {
        console.error("Error:", error);
        alert("Có lỗi xảy ra. Vui lòng thử lại.");
    });
});

// Set default datetime
document.getElementById("productSaleDate").value = new Date().toISOString().slice(0, 16);

// Auto-refresh mỗi 30 giây
setInterval(() => {
    if (!document.querySelector(".modal.show")) {
        location.reload();
    }
}, 30000);
</script>';

include 'layout.php';
?>