<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Quản lý nhân viên</h1>
            <p class="page-subtitle text-muted">Quản lý thông tin và hiệu suất nhân viên</p>
        </div>
        <div class="col-auto">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addEmployeeModal">
                <i class="fas fa-user-plus me-2"></i>Thêm nhân viên
            </button>
        </div>
    </div>
</div>

<!-- Employee Statistics -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tổng nhân viên</div>
                        <div class="value text-primary" id="totalEmployees">' . (isset($employees) ? count($employees) : 12) . '</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+2 người tháng này</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Đang làm việc</div>
                        <div class="value text-success" id="activeEmployees">8</div>
                        <div class="trend text-success">
                            <i class="fas fa-user-check me-1"></i>
                            <span>67% có mặt hôm nay</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-user-clock"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Hiệu suất trung bình</div>
                        <div class="value text-warning" id="avgPerformance">85%</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+3% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số/người</div>
                        <div class="value text-info" id="avgSalesPerEmployee">' . number_format(3750000, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>+8% so với tháng trước</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Employee List -->
    <div class="col-xl-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Danh sách nhân viên</h5>
                <div class="employee-filters">
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" placeholder="Tìm kiếm nhân viên..." id="employeeSearch">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            Lọc
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item filter-option" href="#" data-filter="all">Tất cả</a></li>
                            <li><a class="dropdown-item filter-option" href="#" data-filter="manager">Quản lý</a></li>
                            <li><a class="dropdown-item filter-option" href="#" data-filter="employee">Nhân viên</a></li>
                            <li><a class="dropdown-item filter-option" href="#" data-filter="active">Đang làm việc</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0" id="employeeTable">
                        <thead class="table-light">
                            <tr>
                                <th>Nhân viên</th>
                                <th>Chức vụ</th>
                                <th>Chi nhánh</th>
                                <th>Doanh số tháng</th>
                                <th>Hiệu suất</th>
                                <th>Trạng thái</th>
                                <th>Thao tác</th>
                            </tr>
                        </thead>
                        <tbody>
                            ' . (function() use ($employees) {
                                $html = '';
                                $sampleEmployees = $employees ?? [
                                    ['id' => 1, 'name' => 'Nguyễn Thị A', 'email' => 'nguyena@spa.com', 'role' => 'manager', 'branch_name' => 'Chi nhánh 1', 'monthly_sales' => 8500000, 'performance' => 95, 'status' => 'active'],
                                    ['id' => 2, 'name' => 'Trần Văn B', 'email' => 'tranb@spa.com', 'role' => 'employee', 'branch_name' => 'Chi nhánh 1', 'monthly_sales' => 6200000, 'performance' => 88, 'status' => 'active'],
                                    ['id' => 3, 'name' => 'Lê Thị C', 'email' => 'lec@spa.com', 'role' => 'employee', 'branch_name' => 'Chi nhánh 2', 'monthly_sales' => 5800000, 'performance' => 82, 'status' => 'active'],
                                    ['id' => 4, 'name' => 'Phạm Văn D', 'email' => 'phamd@spa.com', 'role' => 'employee', 'branch_name' => 'Chi nhánh 1', 'monthly_sales' => 4500000, 'performance' => 75, 'status' => 'inactive'],
                                    ['id' => 5, 'name' => 'Hoàng Thị E', 'email' => 'hoange@spa.com', 'role' => 'employee', 'branch_name' => 'Chi nhánh 2', 'monthly_sales' => 7200000, 'performance' => 90, 'status' => 'active']
                                ];
                                
                                foreach($sampleEmployees as $employee) {
                                    $roleText = $employee['role'] == 'manager' ? 'Quản lý' : 'Nhân viên';
                                    $roleBadge = $employee['role'] == 'manager' ? 'bg-primary' : 'bg-secondary';
                                    
                                    $statusText = $employee['status'] == 'active' ? 'Đang làm việc' : 'Nghỉ việc';
                                    $statusBadge = $employee['status'] == 'active' ? 'bg-success' : 'bg-danger';
                                    
                                    $performanceColor = $employee['performance'] >= 90 ? 'text-success' : 
                                                       ($employee['performance'] >= 80 ? 'text-warning' : 'text-danger');
                                    
                                    $html .= '
                                    <tr class="employee-row" data-role="' . $employee['role'] . '" data-status="' . $employee['status'] . '">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="employee-avatar me-3">
                                                    ' . strtoupper(substr($employee['name'], 0, 1)) . '
                                                </div>
                                                <div>
                                                    <div class="employee-name">' . htmlspecialchars($employee['name']) . '</div>
                                                    <div class="employee-email text-muted small">' . htmlspecialchars($employee['email']) . '</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge ' . $roleBadge . '">' . $roleText . '</span>
                                        </td>
                                        <td>' . htmlspecialchars($employee['branch_name']) . '</td>
                                        <td>
                                            <div class="fw-bold">' . number_format($employee['monthly_sales'], 0, ',', '.') . 'đ</div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="performance-bar me-2">
                                                    <div class="progress" style="width: 60px; height: 6px;">
                                                        <div class="progress-bar bg-' . ($employee['performance'] >= 90 ? 'success' : ($employee['performance'] >= 80 ? 'warning' : 'danger')) . '" 
                                                             style="width: ' . $employee['performance'] . '%"></div>
                                                    </div>
                                                </div>
                                                <span class="' . $performanceColor . ' fw-bold">' . $employee['performance'] . '%</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge ' . $statusBadge . '">' . $statusText . '</span>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <button class="btn btn-outline-primary" onclick="viewEmployee(' . $employee['id'] . ')" title="Xem chi tiết">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <button class="btn btn-outline-secondary" onclick="editEmployee(' . $employee['id'] . ')" title="Chỉnh sửa">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button class="btn btn-outline-danger" onclick="deleteEmployee(' . $employee['id'] . ')" title="Xóa">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>';
                                }
                                return $html;
                            })() . '
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Employee Performance & Quick Actions -->
    <div class="col-xl-4 mb-4">
        <!-- Top Performers -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Nhân viên xuất sắc tháng</h5>
            </div>
            <div class="card-body p-0">
                <div class="top-performers">
                    <div class="performer-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="performer-rank me-3">
                                <i class="fas fa-crown text-warning"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="performer-name">Nguyễn Thị A</div>
                                <div class="performer-stats text-muted small">95% hiệu suất • 8.5M doanh số</div>
                            </div>
                            <div class="performer-badge">
                                <span class="badge bg-warning">MVP</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="performer-item p-3 border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="performer-rank me-3">
                                <i class="fas fa-medal text-secondary"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="performer-name">Hoàng Thị E</div>
                                <div class="performer-stats text-muted small">90% hiệu suất • 7.2M doanh số</div>
                            </div>
                            <div class="performer-badge">
                                <span class="badge bg-success">Xuất sắc</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="performer-item p-3">
                        <div class="d-flex align-items-center">
                            <div class="performer-rank me-3">
                                <i class="fas fa-star text-info"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="performer-name">Trần Văn B</div>
                                <div class="performer-stats text-muted small">88% hiệu suất • 6.2M doanh số</div>
                            </div>
                            <div class="performer-badge">
                                <span class="badge bg-info">Tốt</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Thao tác nhanh</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-primary btn-sm" onclick="exportEmployeeReport()">
                        <i class="fas fa-download me-2"></i>Xuất báo cáo nhân viên
                    </button>
                    <button class="btn btn-success btn-sm" onclick="sendNotification()">
                        <i class="fas fa-bell me-2"></i>Gửi thông báo
                    </button>
                    <button class="btn btn-info btn-sm" onclick="scheduleTraining()">
                        <i class="fas fa-graduation-cap me-2"></i>Lên lịch đào tạo
                    </button>
                    <button class="btn btn-warning btn-sm" onclick="reviewPerformance()">
                        <i class="fas fa-chart-bar me-2"></i>Đánh giá hiệu suất
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Recent Activities -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Hoạt động gần đây</h5>
            </div>
            <div class="card-body p-0">
                <div class="activity-list">
                    <div class="activity-item p-3 border-bottom">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-user-plus text-success"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text">Thêm nhân viên mới: <strong>Võ Thị F</strong></div>
                                <div class="activity-time text-muted small">2 giờ trước</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="activity-item p-3 border-bottom">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-edit text-info"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text">Cập nhật thông tin: <strong>Trần Văn B</strong></div>
                                <div class="activity-time text-muted small">5 giờ trước</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="activity-item p-3">
                        <div class="d-flex">
                            <div class="activity-icon me-3">
                                <i class="fas fa-trophy text-warning"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="activity-text"><strong>Nguyễn Thị A</strong> đạt mục tiêu KPI</div>
                                <div class="activity-time text-muted small">1 ngày trước</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Employee Modal -->
<div class="modal fade" id="addEmployeeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Thêm nhân viên mới</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addEmployeeForm" method="POST" action="/api/employees/create">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="employeeName" class="form-label">Họ và tên</label>
                                <input type="text" class="form-control" id="employeeName" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="employeeEmail" class="form-label">Email</label>
                                <input type="email" class="form-control" id="employeeEmail" name="email" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="employeePhone" class="form-label">Số điện thoại</label>
                                <input type="tel" class="form-control" id="employeePhone" name="phone">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="employeeRole" class="form-label">Chức vụ</label>
                                <select class="form-select" id="employeeRole" name="role" required>
                                    <option value="">Chọn chức vụ</option>
                                    <option value="manager">Quản lý</option>
                                    <option value="employee">Nhân viên</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="employeeBranch" class="form-label">Chi nhánh</label>
                                <select class="form-select" id="employeeBranch" name="branch_id" required>
                                    <option value="">Chọn chi nhánh</option>
                                    <option value="1">Chi nhánh 1</option>
                                    <option value="2">Chi nhánh 2</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="employeeStartDate" class="form-label">Ngày bắt đầu làm việc</label>
                                <input type="date" class="form-control" id="employeeStartDate" name="start_date" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="employeePassword" class="form-label">Mật khẩu tạm thời</label>
                        <input type="password" class="form-control" id="employeePassword" name="password" required>
                        <div class="form-text">Nhân viên sẽ được yêu cầu đổi mật khẩu khi đăng nhập lần đầu</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">Thêm nhân viên</button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.employee-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 0.9rem;
}
.employee-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.employee-email {
    font-size: 0.8rem;
}
.performance-bar .progress {
    border-radius: 3px;
}
.activity-icon {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}
.activity-text {
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}
.activity-time {
    font-size: 0.8rem;
}
.performer-rank {
    width: 32px;
    text-align: center;
}
.performer-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.performer-stats {
    font-size: 0.8rem;
}
</style>

<script>
// Search functionality
document.getElementById("employeeSearch").addEventListener("input", function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll(".employee-row");
    
    rows.forEach(row => {
        const name = row.querySelector(".employee-name").textContent.toLowerCase();
        const email = row.querySelector(".employee-email").textContent.toLowerCase();
        
        if (name.includes(searchTerm) || email.includes(searchTerm)) {
            row.style.display = "";
        } else {
            row.style.display = "none";
        }
    });
});

// Filter functionality
document.querySelectorAll(".filter-option").forEach(option => {
    option.addEventListener("click", function(e) {
        e.preventDefault();
        const filter = this.dataset.filter;
        const rows = document.querySelectorAll(".employee-row");
        
        rows.forEach(row => {
            let show = true;
            
            if (filter === "manager" && row.dataset.role !== "manager") {
                show = false;
            } else if (filter === "employee" && row.dataset.role !== "employee") {
                show = false;
            } else if (filter === "active" && row.dataset.status !== "active") {
                show = false;
            }
            
            row.style.display = show ? "" : "none";
        });
    });
});

// Employee actions
function viewEmployee(id) {
    alert("Xem chi tiết nhân viên ID: " + id);
}

function editEmployee(id) {
    alert("Chỉnh sửa nhân viên ID: " + id);
}

function deleteEmployee(id) {
    if (confirm("Bạn có chắc chắn muốn xóa nhân viên này?")) {
        fetch("/api/employees/delete", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({ employee_id: id })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert("Có lỗi xảy ra. Vui lòng thử lại.");
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        });
    }
}

// Quick actions
function exportEmployeeReport() {
    alert("Tính năng xuất báo cáo sẽ được phát triển trong phiên bản tiếp theo");
}

function sendNotification() {
    alert("Tính năng gửi thông báo sẽ được phát triển trong phiên bản tiếp theo");
}

function scheduleTraining() {
    alert("Tính năng lên lịch đào tạo sẽ được phát triển trong phiên bản tiếp theo");
}

function reviewPerformance() {
    alert("Tính năng đánh giá hiệu suất sẽ được phát triển trong phiên bản tiếp theo");
}

// Add employee form
document.getElementById("addEmployeeForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    fetch("/api/employees/create", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById("addEmployeeModal")).hide();
            location.reload();
        } else {
            alert("Có lỗi xảy ra. Vui lòng thử lại.");
        }
    })
    .catch(error => {
        console.error("Error:", error);
        alert("Có lỗi xảy ra. Vui lòng thử lại.");
    });
});

// Set default start date
document.getElementById("employeeStartDate").value = new Date().toISOString().split("T")[0];

// Auto-refresh mỗi 60 giây
setInterval(() => {
    if (!document.querySelector(".modal.show")) {
        location.reload();
    }
}, 60000);
</script>';

include 'layout.php';
?>