<?php
$content = '
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="row align-items-center">
        <div class="col">
            <h1 class="page-title">Dashboard</h1>
            <p class="page-subtitle text-muted">Tổng quan hiệu suất và hoạt động</p>
        </div>
        <div class="col-auto">
            <div class="btn-group" role="group">
                <input type="radio" class="btn-check" name="period" id="today" autocomplete="off" checked>
                <label class="btn btn-outline-primary" for="today">Hôm nay</label>
                
                <input type="radio" class="btn-check" name="period" id="week" autocomplete="off">
                <label class="btn btn-outline-primary" for="week">Tuần này</label>
                
                <input type="radio" class="btn-check" name="period" id="month" autocomplete="off">
                <label class="btn btn-outline-primary" for="month">Tháng này</label>
            </div>
        </div>
    </div>
</div>

<!-- Stats Overview -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Doanh số hôm nay</div>
                        <div class="value text-primary">' . number_format((float)$todaySales, 0, ',', '.') . 'đ</div>
                        <div class="trend text-success">
                            <i class="fas fa-arrow-up me-1"></i>
                            <span>12% so với hôm qua</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Nhiệm vụ hoàn thành</div>
                        <div class="value text-success">' . (int)$completedTasks . '/' . (int)$totalTasks . '</div>
                        <div class="progress thin-progress mt-2">
                            <div class="progress-bar bg-success" style="width: ' . ($totalTasks > 0 ? ((int)$completedTasks / (int)$totalTasks) * 100 : 0) . '%"></div>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-tasks"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Tiến độ KPI tháng</div>
                        <div class="value text-warning">' . (int)$kpiProgress . '%</div>
                        <div class="trend ' . ($kpiProgress >= 80 ? 'text-success' : ($kpiProgress >= 50 ? 'text-warning' : 'text-danger')) . '">
                            <i class="fas ' . ($kpiProgress >= 80 ? 'fa-arrow-up' : ($kpiProgress >= 50 ? 'fa-minus' : 'fa-arrow-down')) . ' me-1"></i>
                            <span>' . ($kpiProgress >= 80 ? 'Vượt mục tiêu' : ($kpiProgress >= 50 ? 'Đang tiến triển' : 'Cần cải thiện')) . '</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card border-start-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-muted small">Nhân viên đang làm</div>
                        <div class="value text-info">' . (int)$activeEmployees . '</div>
                        <div class="trend text-success">
                            <i class="fas fa-user-check me-1"></i>
                            <span>' . ($activeEmployees > 0 ? round(((int)$activeEmployees / ((int)$activeEmployees + 5)) * 100) : 0) . '% có mặt</span>
                        </div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-user-clock"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Daily Tasks & KPI Progress -->
    <div class="col-xl-8 mb-4">
        <div class="row">
            <!-- Daily Tasks -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Nhiệm vụ hàng ngày</h5>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="/tasks"><i class="fas fa-list me-2"></i>Xem tất cả</a></li>
                                <li><a class="dropdown-item" href="#"><i class="fas fa-plus me-2"></i>Thêm nhiệm vụ</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="task-list">
                            ' . (function() use ($dailyTasks) {
                                $html = '';
                                $count = 0;
                                foreach($dailyTasks as $task) {
                                    if ($count >= 5) break;
                                    $html .= '
                                    <div class="task-item ' . ($task['completed'] ? 'completed' : '') . '">
                                        <div class="form-check mb-0">
                                            <input class="form-check-input task-checkbox" type="checkbox" 
                                                   id="task' . $task['id'] . '" ' . ($task['completed'] ? 'checked' : '') . ' 
                                                   data-task-id="' . $task['id'] . '">
                                            <label class="form-check-label w-100" for="task' . $task['id'] . '">
                                                <div class="task-title">' . htmlspecialchars($task['title']) . '</div>
                                                ' . (!$task['completed'] ? '
                                                <div class="task-description">' . htmlspecialchars($task['description']) . '</div>' : '') . '
                                            </label>
                                        </div>
                                        ' . (!$task['completed'] ? '
                                        <div class="task-actions">
                                            <button class="btn btn-sm btn-outline-secondary">
                                                <i class="fas fa-clock"></i>
                                            </button>
                                        </div>' : '') . '
                                    </div>';
                                    $count++;
                                }
                                if (empty($dailyTasks)) {
                                    $html .= '
                                    <div class="text-center py-4">
                                        <i class="fas fa-check-circle text-muted fa-2x mb-2"></i>
                                        <p class="text-muted">Không có nhiệm vụ nào</p>
                                    </div>';
                                }
                                return $html;
                            })() . '
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- KPI Progress -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header">
                        <h5 class="mb-0">Tiến độ KPI tháng ' . date('m/Y') . '</h5>
                    </div>
                    <div class="card-body">
                        ' . (function() use ($kpiItems) {
                            $html = '';
                            if (empty($kpiItems)) {
                                // Dữ liệu mẫu nếu chưa có KPI
                                $kpiItems = [
                                    ['name' => 'Doanh số dịch vụ', 'target' => 50000000, 'achieved' => 38500000, 'percentage' => 77],
                                    ['name' => 'Doanh số sản phẩm', 'target' => 20000000, 'achieved' => 15200000, 'percentage' => 76],
                                    ['name' => 'Khách hàng mới', 'target' => 30, 'achieved' => 22, 'percentage' => 73],
                                ];
                            }
                            foreach($kpiItems as $kpi) {
                                // Đảm bảo các giá trị là số
                                $current = isset($kpi['achieved']) ? (float)$kpi['achieved'] : (float)($kpi['current'] ?? 0);
                                $target = (float)$kpi['target'];
                                $percentage = isset($kpi['percentage']) ? (int)$kpi['percentage'] : ($target > 0 ? min(100, round(($current / $target) * 100)) : 0);
                                
                                $progressClass = $percentage >= 80 ? 'bg-success' : 
                                               ($percentage >= 50 ? 'bg-warning' : 'bg-danger');
                                $html .= '
                                <div class="kpi-item mb-3">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="kpi-name">' . htmlspecialchars($kpi['name']) . '</span>
                                        <span class="kpi-value">' . $percentage . '%</span>
                                    </div>
                                    <div class="progress kpi-progress">
                                        <div class="progress-bar ' . $progressClass . '" role="progressbar" 
                                             style="width: ' . $percentage . '%"></div>
                                    </div>
                                    <div class="kpi-details mt-1">
                                        <small class="text-muted">' . number_format($current, 0, ',', '.') . ' / ' . number_format($target, 0, ',', '.') . '</small>
                                    </div>
                                </div>';
                            }
                            if (empty($kpiItems)) {
                                $html .= '
                                <div class="text-center py-4">
                                    <i class="fas fa-chart-line text-muted fa-2x mb-2"></i>
                                    <p class="text-muted">Chưa có KPI được thiết lập</p>
                                </div>';
                            }
                            return $html;
                        })() . '
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Sales Chart -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Biểu đồ doanh số 4 tuần gần nhất</h5>
                <div class="chart-legend">
                    <span class="legend-item me-3">
                        <span class="legend-color bg-primary"></span>
                        <span class="legend-label">Dịch vụ</span>
                    </span>
                    <span class="legend-item">
                        <span class="legend-color bg-success"></span>
                        <span class="legend-label">Sản phẩm</span>
                    </span>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="salesChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Activity & Quick Stats -->
    <div class="col-xl-4 mb-4">
        <!-- Quick Stats -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Thống kê nhanh</h5>
            </div>
            <div class="card-body">
                <div class="quick-stats">
                    <div class="stat-item d-flex justify-content-between align-items-center py-2 border-bottom">
                        <span class="stat-label">Doanh số trung bình/ngày</span>
                        <span class="stat-value">' . number_format((float)$todaySales * 0.8, 0, ',', '.') . 'đ</span>
                    </div>
                    <div class="stat-item d-flex justify-content-between align-items-center py-2 border-bottom">
                        <span class="stat-label">Tỷ lệ hoàn thành KPI</span>
                        <span class="stat-value">' . (int)$kpiProgress . '%</span>
                    </div>
                    <div class="stat-item d-flex justify-content-between align-items-center py-2 border-bottom">
                        <span class="stat-label">Nhiệm vụ còn lại</span>
                        <span class="stat-value">' . ((int)$totalTasks - (int)$completedTasks) . '</span>
                    </div>
                    <div class="stat-item d-flex justify-content-between align-items-center py-2">
                        <span class="stat-label">Hiệu suất làm việc</span>
                        <span class="stat-value">' . ($totalTasks > 0 ? round(((int)$completedTasks / (int)$totalTasks) * 100) : 0) . '%</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Recent Sales -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Giao dịch gần đây</h5>
                <a href="/sales" class="btn btn-sm btn-outline-primary">Xem tất cả</a>
            </div>
            <div class="card-body p-0">
                <div class="sales-list">
                    ' . (function() use ($recentSales) {
                        $html = '';
                        $count = 0;
                        foreach($recentSales as $sale) {
                            if ($count >= 6) break;
                            $typeIcon = $sale['type'] == 'service' ? 'fa-concierge-bell' : 
                                       ($sale['type'] == 'product' ? 'fa-box' : 'fa-receipt');
                            $typeColor = $sale['type'] == 'service' ? 'primary' : 
                                        ($sale['type'] == 'product' ? 'success' : 'info');
                            
                            $employeeName = $sale['employee_name'] ?? ($sale['employee'] ?? 'N/A');
                            
                            $html .= '
                            <div class="sale-item p-3 border-bottom">
                                <div class="d-flex align-items-center">
                                    <div class="sale-icon me-3">
                                        <i class="fas ' . $typeIcon . ' text-' . $typeColor . '"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="sale-description">' . htmlspecialchars($sale['description']) . '</div>
                                        <div class="sale-meta text-muted small">
                                            ' . date('H:i', strtotime($sale['sale_date'])) . ' • ' . htmlspecialchars($employeeName) . '
                                        </div>
                                    </div>
                                    <div class="sale-amount text-end">
                                        <div class="fw-bold text-' . $typeColor . '">' . number_format((float)$sale['amount'], 0, ',', '.') . 'đ</div>
                                        <small class="text-muted">' . ($sale['type'] == 'service' ? 'Dịch vụ' : 'Sản phẩm') . '</small>
                                    </div>
                                </div>
                            </div>';
                            $count++;
                        }
                        if (empty($recentSales)) {
                            $html .= '
                            <div class="text-center py-4">
                                <i class="fas fa-shopping-cart text-muted fa-2x mb-2"></i>
                                <p class="text-muted">Chưa có giao dịch nào</p>
                            </div>';
                        }
                        return $html;
                    })() . '
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.page-header {
    border-bottom: 1px solid #e9ecef;
    padding-bottom: 1rem;
}
.page-title {
    font-size: 1.75rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 0.25rem;
}
.page-subtitle {
    font-size: 0.95rem;
}
.stat-card {
    border-left: 4px solid;
    transition: all 0.3s ease;
}
.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}
.border-start-primary { border-left-color: #4a90e2 !important; }
.border-start-success { border-left-color: #55efc4 !important; }
.border-start-warning { border-left-color: #fdcb6e !important; }
.border-start-info { border-left-color: #7ed6df !important; }
.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
}
.stat-card.border-start-primary .stat-icon { background: rgba(74, 144, 226, 0.1); color: #4a90e2; }
.stat-card.border-start-success .stat-icon { background: rgba(85, 239, 196, 0.1); color: #55efc4; }
.stat-card.border-start-warning .stat-icon { background: rgba(253, 203, 110, 0.1); color: #fdcb6e; }
.stat-card.border-start-info .stat-icon { background: rgba(126, 214, 223, 0.1); color: #7ed6df; }
.value {
    font-size: 1.75rem;
    font-weight: 700;
    margin: 0.25rem 0;
}
.trend {
    font-size: 0.85rem;
    font-weight: 500;
}
.thin-progress {
    height: 4px;
    background-color: #f1f3f4;
}
.task-list .task-item {
    padding: 1rem 1.25rem;
    border-bottom: 1px solid #f8f9fa;
    display: flex;
    align-items: center;
    transition: background-color 0.2s;
}
.task-list .task-item:hover {
    background-color: #f8f9fa;
}
.task-list .task-item:last-child {
    border-bottom: none;
}
.task-list .task-item.completed {
    background-color: #f8fff9;
}
.task-list .task-item.completed .task-title {
    text-decoration: line-through;
    color: #6c757d;
}
.task-title {
    font-weight: 500;
    margin-bottom: 0.25rem;
}
.task-description {
    font-size: 0.85rem;
    color: #6c757d;
}
.task-actions {
    margin-left: auto;
}
.kpi-item {
    padding: 0.5rem 0;
}
.kpi-name {
    font-weight: 500;
    font-size: 0.9rem;
}
.kpi-value {
    font-weight: 600;
    color: #2c3e50;
}
.kpi-progress {
    height: 8px;
    border-radius: 4px;
}
.kpi-details {
    font-size: 0.8rem;
}
.chart-legend {
    display: flex;
    align-items: center;
}
.legend-item {
    display: flex;
    align-items: center;
    font-size: 0.85rem;
}
.legend-color {
    width: 12px;
    height: 12px;
    border-radius: 2px;
    margin-right: 0.5rem;
}
.quick-stats .stat-item:last-child {
    border-bottom: none !important;
}
.stat-label {
    color: #6c757d;
    font-size: 0.9rem;
}
.stat-value {
    font-weight: 600;
    color: #2c3e50;
}
.sales-list .sale-item:last-child {
    border-bottom: none !important;
}
.sale-icon {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f8f9fa;
}
.sale-description {
    font-weight: 500;
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}
.sale-meta {
    font-size: 0.8rem;
}
.sale-amount {
    min-width: 80px;
}
</style>

<script>
// Biểu đồ doanh số với dữ liệu thực tế hơn
const salesCtx = document.getElementById(\'salesChart\').getContext(\'2d\');
const salesChart = new Chart(salesCtx, {
    type: \'line\',
    data: {
        labels: [\'Tuần 1\', \'Tuần 2\', \'Tuần 3\', \'Tuần 4\'],
        datasets: [{
            label: \'Doanh số dịch vụ\',
            data: [12000000, 19000000, 15000000, 25000000],
            borderColor: \'#4a90e2\',
            backgroundColor: \'rgba(74, 144, 226, 0.05)\',
            borderWidth: 2,
            tension: 0.4,
            fill: true
        }, {
            label: \'Doanh số sản phẩm\',
            data: [8000000, 12000000, 10000000, 15000000],
            borderColor: \'#55efc4\',
            backgroundColor: \'rgba(85, 239, 196, 0.05)\',
            borderWidth: 2,
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            },
            tooltip: {
                mode: \'index\',
                intersect: false,
                callbacks: {
                    label: function(context) {
                        let label = context.dataset.label || \'\';
                        if (label) {
                            label += \': \';
                        }
                        label += new Intl.NumberFormat(\'vi-VN\', { 
                            style: \'currency\', 
                            currency: \'VND\',
                            minimumFractionDigits: 0 
                        }).format(context.raw);
                        return label;
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                grid: {
                    color: \'rgba(0, 0, 0, 0.05)\'
                },
                ticks: {
                    callback: function(value) {
                        if (value >= 1000000) {
                            return (value / 1000000) + \' tr\';
                        }
                        return new Intl.NumberFormat(\'vi-VN\', { 
                            style: \'currency\', 
                            currency: \'VND\', 
                            minimumFractionDigits: 0 
                        }).format(value);
                    }
                }
            },
            x: {
                grid: {
                    display: false
                }
            }
        },
        interaction: {
            mode: \'nearest\',
            axis: \'x\',
            intersect: false
        }
    }
});

// Xử lý tích chọn nhiệm vụ
document.querySelectorAll(\'.task-checkbox\').forEach(checkbox => {
    checkbox.addEventListener(\'change\', function() {
        const taskItem = this.closest(\'.task-item\');
        const taskId = this.dataset.taskId;
        const completed = this.checked;
        
        if (this.checked) {
            taskItem.classList.add(\'completed\');
            // Gửi yêu cầu AJAX để cập nhật trạng thái hoàn thành
            fetch(\'/api/task/complete\', {
                method: \'POST\',
                headers: {
                    \'Content-Type\': \'application/json\',
                },
                body: JSON.stringify({
                    task_id: taskId,
                    completed: completed
                })
            }).catch(error => {
                console.error(\'Error:\', error);
                this.checked = false;
                taskItem.classList.remove(\'completed\');
            });
        } else {
            taskItem.classList.remove(\'completed\');
        }
    });
});

// Xử lý chuyển đổi period
document.querySelectorAll(\'input[name="period"]\').forEach(radio => {
    radio.addEventListener(\'change\', function() {
        // Có thể thêm logic để tải lại dữ liệu theo period
        console.log(\'Period changed to:\', this.id);
    });
});
</script>';

include 'layout.php';
?>