<?php
class Employee {
    private $conn;
    private $table_name = "users";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function getAllEmployees() {
        $query = "SELECT u.*, b.name as branch_name 
                  FROM users u 
                  LEFT JOIN branches b ON u.branch_id = b.id 
                  WHERE u.role IN ('manager', 'employee')
                  ORDER BY u.name";
        
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getEmployeesByBranch($branch_id) {
        $query = "SELECT u.*, b.name as branch_name 
                  FROM users u 
                  LEFT JOIN branches b ON u.branch_id = b.id 
                  WHERE u.branch_id = :branch_id 
                  AND u.role IN ('manager', 'employee')
                  ORDER BY u.name";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':branch_id', $branch_id);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function createEmployee($name, $email, $password, $role, $branch_id, $phone = null) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        $query = "INSERT INTO users (name, email, password, role, branch_id, phone, created_at) 
                  VALUES (:name, :email, :password, :role, :branch_id, :phone, NOW())";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':password', $hashed_password);
        $stmt->bindParam(':role', $role);
        $stmt->bindParam(':branch_id', $branch_id);
        $stmt->bindParam(':phone', $phone);
        
        return $stmt->execute();
    }
    
    public function deleteEmployee($employee_id) {
        // Soft delete - chỉ cập nhật trạng thái
        $query = "UPDATE users SET is_active = 0, updated_at = NOW() 
                  WHERE id = :employee_id AND role != 'owner'";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':employee_id', $employee_id);
        
        return $stmt->execute();
    }
}
?>