<?php
class Controller {
    protected $db;

    public function __construct() {
        $this->db = $this->getDB();
    }

    protected function getDB() {
        $database = new Database();
        return $database->getConnection();
    }

    public function model($model) {
        require_once '../app/models/' . $model . '.php';
        return new $model($this->db);
    }

    public function view($view, $data = []) {
        // Extract data to variables
        extract($data);
        
        // Check if view file exists
        $viewFile = '../app/views/' . $view . '.php';
        if (file_exists($viewFile)) {
            require_once $viewFile;
        } else {
            die('View không tồn tại: ' . $viewFile);
        }
    }

    protected function checkAuth() {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit();
        }
    }

    protected function checkPermission($allowedRoles = []) {
        $this->checkAuth();
        
        if (!empty($allowedRoles) && !in_array($_SESSION['user_role'], $allowedRoles)) {
            http_response_code(403);
            die('Bạn không có quyền truy cập trang này');
        }
    }

    protected function jsonResponse($data, $statusCode = 200) {
        http_response_code($statusCode);
        header('Content-Type: application/json');
        echo json_encode($data);
        exit();
    }
}
?>